/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.util;

import com.novell.nds.dirxml.driver.xds.util.XDSUtil;

public abstract class GUIDUtil {
    public static final char DELIMITER_BEGIN = '{';
    public static final char DELIMITER_END = '}';
    public static final char DELIMITER_SECTION = '-';
    static final int GUID_LENGTH_DELIMITED = 38;
    static final int GUID_LENGTH_UNDELIMITED = 32;
    private static final char[] binToAscii = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] asciiToBinLo = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15};
    private static final int[] asciiToBinHi = new int[]{0, 16, 32, 48, 64, 80, 96, 112, 128, 144, 0, 0, 0, 0, 0, 0, 0, 160, 176, 192, 208, 224, 240};

    public static boolean isDelimiter(char c) {
        return c == '-' || c == '{' || c == '}';
    }

    public static String stripDelimiters(String string) {
        if (XDSUtil.noValue(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (GUIDUtil.isDelimiter(cArray[i])) continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static void delimit(String string, StringBuffer stringBuffer) {
        if (stringBuffer != null && string != null) {
            if (string.length() != 32) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append('{');
                stringBuffer.append(string.substring(0, 8));
                stringBuffer.append('-');
                stringBuffer.append(string.substring(8, 12));
                stringBuffer.append('-');
                stringBuffer.append(string.substring(12, 16));
                stringBuffer.append('-');
                stringBuffer.append(string.substring(16, 20));
                stringBuffer.append('-');
                stringBuffer.append(string.substring(20));
                stringBuffer.append('}');
            }
        }
    }

    public static boolean isValid(String string) {
        if (string == null || string.length() < 38) {
            return false;
        }
        char[] cArray = string.toCharArray();
        return cArray[0] == '{' && cArray[9] == '-' && cArray[14] == '-' && cArray[19] == '-' && cArray[24] == '-' && cArray[37] == '}' && GUIDUtil.isValidHex(cArray, 1, 9) && GUIDUtil.isValidHex(cArray, 10, 14) && GUIDUtil.isValidHex(cArray, 15, 19) && GUIDUtil.isValidHex(cArray, 20, 24) && GUIDUtil.isValidHex(cArray, 25, 37);
    }

    private static boolean isValidHex(char[] cArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static String binGuidToString(byte[] byArray) {
        GUIDUtil.byteSwap(0, 3, byArray);
        GUIDUtil.byteSwap(4, 5, byArray);
        GUIDUtil.byteSwap(6, 7, byArray);
        String string = GUIDUtil.encodeAsciiHex(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append(string.substring(0, 8));
        stringBuffer.append('-');
        stringBuffer.append(string.substring(8, 12));
        stringBuffer.append('-');
        stringBuffer.append(string.substring(12, 16));
        stringBuffer.append('-');
        stringBuffer.append(string.substring(16, 20));
        stringBuffer.append('-');
        stringBuffer.append(string.substring(20));
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static byte[] stringGuidtoBin(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() - 4);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '-') continue;
            stringBuffer.append(c);
        }
        byte[] byArray = GUIDUtil.decodeAsciiHex(stringBuffer.toString());
        GUIDUtil.byteSwap(0, 3, byArray);
        GUIDUtil.byteSwap(4, 5, byArray);
        GUIDUtil.byteSwap(6, 7, byArray);
        return byArray;
    }

    static byte[] decodeAsciiHex(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            byArray[n2++] = (byte)(asciiToBinHi[string.charAt(i) - 48] + asciiToBinLo[string.charAt(i + 1) - 48]);
        }
        return byArray;
    }

    private static String encodeAsciiHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(binToAscii[by >> 4 & 0xF]);
            stringBuffer.append(binToAscii[by & 0xF]);
        }
        return stringBuffer.toString();
    }

    private static void byteSwap(int n, int n2, byte[] byArray) {
        for (int i = n; i < n + (n2 + 1 - n) / 2; ++i) {
            byte by = byArray[i];
            int n3 = n2 - (i - n);
            byArray[i] = byArray[n3];
            byArray[n3] = by;
        }
    }
}

