/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.util;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.util.Errors;
import com.novell.nds.dirxml.driver.xds.util.Java;
import com.novell.nds.dirxml.driver.xds.util.Lib;
import com.novell.nds.dirxml.driver.xds.util.Lib_1_4;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XDSUtil {
    private static final Set CHILD_ELEMENTS_OF_IN_OUT = new HashSet();

    private XDSUtil() {
    }

    public static boolean isChildOfInputOrOutput(Element element) {
        boolean bl = false;
        if (element != null) {
            bl = CHILD_ELEMENTS_OF_IN_OUT.contains(element.getTagName());
        }
        return bl;
    }

    public static final boolean isInputOrOutputElement(Element element) {
        boolean bl = false;
        if (element != null) {
            bl = "input".compareTo(element.getTagName()) == 0 || "output".compareTo(element.getTagName()) == 0;
        }
        return bl;
    }

    public static final boolean isNDSElement(Element element) {
        boolean bl = false;
        if (element != null) {
            bl = "nds".compareTo(element.getTagName()) == 0;
        }
        return bl;
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        return byteArrayOutputStream.toString();
    }

    public static long toMillis(int n) {
        return n * 1000;
    }

    public static XDSStatusElement appendStatus(StatusDocument statusDocument, StatusAttributes statusAttributes, String string) {
        XDSStatusElement xDSStatusElement = statusDocument.appendStatusElement();
        if (statusAttributes != null) {
            xDSStatusElement.setLevel(statusAttributes.getLevel());
            xDSStatusElement.setType(statusAttributes.getType());
            xDSStatusElement.setEventID(statusAttributes.getEventID());
        }
        xDSStatusElement.descriptionAppend(string);
        return xDSStatusElement;
    }

    private static XDSStatusElement appendStatus(StatusDocument statusDocument, StatusAttributes statusAttributes, XDSParameterException xDSParameterException, XmlDocument xmlDocument) {
        XDSStatusElement xDSStatusElement = null;
        for (XDSParameterException xDSParameterException2 = xDSParameterException; xDSParameterException2 != null; xDSParameterException2 = xDSParameterException2.getNext()) {
            xDSStatusElement = XDSUtil.appendStatus(statusDocument, statusAttributes, xDSParameterException2.getMessage());
        }
        if (xDSStatusElement != null && xmlDocument != null) {
            xDSStatusElement.documentAppend(xmlDocument);
        }
        return xDSStatusElement;
    }

    private static String getDescription(String string, Throwable throwable) {
        if (string == null) {
            if (throwable == null) {
                return null;
            }
            return throwable.toString();
        }
        return string;
    }

    public static XDSStatusElement appendStatus(StatusDocument statusDocument, StatusAttributes statusAttributes, String string, Exception exception, boolean bl, XmlDocument xmlDocument) {
        XDSStatusElement xDSStatusElement = null;
        if (statusDocument != null) {
            if (exception instanceof XDSParameterException) {
                xDSStatusElement = XDSUtil.appendStatus(statusDocument, statusAttributes, (XDSParameterException)exception, xmlDocument);
            } else {
                xDSStatusElement = statusDocument.appendStatusElement();
                if (statusAttributes != null) {
                    xDSStatusElement.setLevel(statusAttributes.getLevel());
                    xDSStatusElement.setType(statusAttributes.getType());
                    xDSStatusElement.setEventID(statusAttributes.getEventID());
                }
                xDSStatusElement.descriptionAppend(XDSUtil.getDescription(string, exception));
                xDSStatusElement.exceptionAppend(exception, bl);
                if (Java.isJRE(1, 4)) {
                    // empty if block
                }
                Lib_1_4.causeAppend(xDSStatusElement.documentImpl(), xDSStatusElement.domElement(), exception, bl);
                xDSStatusElement.documentAppend(xmlDocument);
            }
        }
        return xDSStatusElement;
    }

    public static void appendXML(Element element, String string) {
        if (XDSUtil.isValue(string) && element != null) {
            Node node;
            Document document = element.getOwnerDocument();
            XmlDocument xmlDocument = new XmlDocument(string);
            Document document2 = xmlDocument.getDocument();
            if (document2 != null && (node = Lib.cloneSubtree(document, document2.getDocumentElement())) != null) {
                element.appendChild(node);
            }
        }
    }

    public static final void appendThrowable(Element element, Throwable throwable, boolean bl) {
        Text text;
        Element element2;
        if (throwable == null || element == null) {
            return;
        }
        Document document = element.getOwnerDocument();
        Element element3 = document.createElement("exception");
        element.appendChild(element3);
        String string = throwable.getClass().getName();
        if (XDSUtil.isValue(string)) {
            element3.setAttribute("class-name", string);
        }
        if (XDSUtil.isValue(string = throwable.getMessage())) {
            element2 = document.createElement("message");
            element3.appendChild(element2);
            text = document.createTextNode(string);
            element2.appendChild(text);
        }
        if (bl && XDSUtil.isValue(string = XDSUtil.getStackTrace(throwable))) {
            element2 = document.createElement("stack-trace");
            element3.appendChild(element2);
            text = document.createTextNode(string);
            element2.appendChild(text);
        }
    }

    public static void appendNode(Node node, Node node2) {
        Document document;
        Node node3;
        if (node != null && node2 != null && (node3 = Lib.cloneSubtree(document = node.getOwnerDocument(), node2)) != null) {
            node.appendChild(node3);
        }
    }

    public static boolean appendStackTrace(Exception exception) {
        return exception instanceof RuntimeException;
    }

    public static boolean isWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return Character.isWhitespace(string.charAt(0));
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isValue(String string) {
        return string != null && !XDSUtil.isWhitespace(string);
    }

    public static final boolean noValue(String string) {
        return string == null || XDSUtil.isWhitespace(string);
    }

    public static String toNull(String string) {
        if (XDSUtil.noValue(string)) {
            return null;
        }
        return string;
    }

    public static String getChildText(Element element) {
        element.normalize();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            short s = nodeList.item(i).getNodeType();
            if (s != 3) continue;
            Text text = (Text)nodeList.item(i);
            return XDSUtil.toNull(text.getData());
        }
        return null;
    }

    public static final boolean isNullOrEmpty(NodeList nodeList) {
        return nodeList == null || nodeList.getLength() == 0;
    }

    public static final Node getFirst(NodeList nodeList) {
        if (XDSUtil.isNullOrEmpty(nodeList)) {
            return null;
        }
        return nodeList.item(0);
    }

    public static void getChildElements(Element element, List list) {
        XDSUtil.getChildNodes(element, 1, list);
    }

    public static void getChildTextNodes(Element element, List list) {
        XDSUtil.getChildNodes(element, 3, list);
    }

    public static void getChildNodes(Element element, int n, List list) {
        list.clear();
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != n) continue;
                list.add(node);
            }
        }
    }

    public static final void checkArg(String string, Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException(Errors.noParamValue(string, n));
        }
    }

    public static final void checkArg(String string, String string2, int n) {
        if (XDSUtil.noValue(string2)) {
            throw new IllegalArgumentException(Errors.noParamValue(string, n));
        }
    }

    public static final String getRDN(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("\\");
        String string2 = n == -1 ? string : string.substring(n + 1, string.length());
        return "".compareTo(string2) == 0 ? null : string2;
    }

    public static boolean isNullOrEmpty(XmlDocument xmlDocument) {
        return xmlDocument == null || xmlDocument.getDocument() == null || xmlDocument.getDocument().getDocumentElement() == null;
    }

    static {
        CHILD_ELEMENTS_OF_IN_OUT.add("add");
        CHILD_ELEMENTS_OF_IN_OUT.add("modify");
        CHILD_ELEMENTS_OF_IN_OUT.add("delete");
        CHILD_ELEMENTS_OF_IN_OUT.add("rename");
        CHILD_ELEMENTS_OF_IN_OUT.add("move");
        CHILD_ELEMENTS_OF_IN_OUT.add("query");
        CHILD_ELEMENTS_OF_IN_OUT.add("query-ex");
        CHILD_ELEMENTS_OF_IN_OUT.add("add-association");
        CHILD_ELEMENTS_OF_IN_OUT.add("modify-association");
        CHILD_ELEMENTS_OF_IN_OUT.add("remove-association");
        CHILD_ELEMENTS_OF_IN_OUT.add("status");
        CHILD_ELEMENTS_OF_IN_OUT.add("check-object-password");
        CHILD_ELEMENTS_OF_IN_OUT.add("modify-password");
        CHILD_ELEMENTS_OF_IN_OUT.add("instance");
        CHILD_ELEMENTS_OF_IN_OUT.add("password");
        CHILD_ELEMENTS_OF_IN_OUT.add("query-token");
        CHILD_ELEMENTS_OF_IN_OUT.add("get-named-password");
        CHILD_ELEMENTS_OF_IN_OUT.add("sync");
        CHILD_ELEMENTS_OF_IN_OUT.add("check-password");
    }
}

