/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;

public class ASCIIEncoder
extends CharEncoder {
    public static final String NAME = "US-ASCII";
    public static final String NAME_SECONDARY = "ASCII";

    public int encodeChars(char[] cArray, int n, int n2, byte[] byArray, int n3) throws CharEncodingException, EncodingBufferFullException {
        int n4 = n;
        int n5 = n3;
        int n6 = n + n2;
        while (n4 < n6) {
            char c = cArray[n4];
            if ('\u0000' <= c && c <= '\u007f') {
                if (n5 >= byArray.length) {
                    throw new EncodingBufferFullException(n5, n4);
                }
            } else {
                if ('\ud800' <= c && c < '\udc00' && n4 + 1 < n6) {
                    char c2 = cArray[++n4];
                    int n7 = (c - 55296 << 10) + (c2 - 56320) + 65536;
                    throw new CharEncodingException(n7, n4, n5);
                }
                throw new CharEncodingException(c & 0xFFFF, n4, n5);
            }
            byArray[n5++] = (byte)c;
            ++n4;
        }
        return n5 - n3;
    }

    public int encodeChar(int n, byte[] byArray, int n2) throws CharEncodingException, EncodingBufferFullException {
        if (n < 127) {
            if (n2 < byArray.length) {
                byArray[n2] = (byte)n;
                return 1;
            }
            throw new EncodingBufferFullException(n2, 0);
        }
        throw new CharEncodingException(n, 0, n2);
    }

    public String getEncoding() {
        return NAME;
    }
}

