/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class EncodingStreamWriter
extends Writer {
    private CharEncoder encoder;
    private OutputStream stream;
    private int outputIndex = 0;
    private byte[] buffer = new byte[8192];

    public EncodingStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, CharEncoder.getEncoder(string));
    }

    public EncodingStreamWriter(OutputStream outputStream, CharEncoder charEncoder) {
        this.stream = outputStream;
        this.encoder = charEncoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            this.buffer = new byte[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferSize() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.buffer.length;
            return n;
        }
    }

    public String getEncoding() {
        return this.encoder.getEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            this.stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.outputIndex > 0) {
                this.stream.write(this.buffer, 0, this.outputIndex);
                this.outputIndex = 0;
                this.stream.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.outputIndex += this.encoder.encodeChar(n & 0xFFFF, this.buffer, this.outputIndex);
            }
            catch (EncodingBufferFullException encodingBufferFullException) {
                if (this.tryFlush()) {
                    this.outputIndex += this.encoder.encodeChar(n & 0xFFFF, this.buffer, this.outputIndex);
                }
                throw encodingBufferFullException;
            }
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                try {
                    if (this.buffer.length - this.outputIndex < 16) {
                        this.flush();
                    }
                    this.outputIndex += this.encoder.encodeChars(cArray, n, n2, this.buffer, this.outputIndex);
                    return;
                }
                catch (CharEncodingException charEncodingException) {
                    this.outputIndex = charEncodingException.getOutputOffset();
                    throw charEncodingException;
                }
                catch (EncodingBufferFullException encodingBufferFullException) {
                    this.outputIndex = encodingBufferFullException.getOutputIndex();
                    if (this.tryFlush()) {
                        n2 -= encodingBufferFullException.getInputIndex() - n;
                        n = encodingBufferFullException.getInputIndex();
                        continue;
                    }
                    throw encodingBufferFullException;
                }
                break;
            }
        }
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    public void write(String string, int n, int n2) throws IOException {
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        this.write(cArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryFlush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.outputIndex <= 0) break block4;
                this.flush();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

