/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.sax;

import com.novell.io.EncodingStreamWriter;
import com.novell.xml.sax.DocumentCommentHandler;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.NamespaceStack;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.util.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class SAXWriter
implements XmlWriter,
DocumentCommentHandler {
    private Parser parser;
    private InputSource inputSource;
    private Locator locator = null;
    private Writer writer;
    private String encoding = null;
    private boolean indent = false;
    private boolean writeDeclaration = false;
    private boolean standalone = false;
    private String doctypePublic = null;
    private String doctypeSystem = null;
    private boolean disableTextEscaping = false;
    private Collection cdataSectionElements = null;
    protected int indentLevel;
    protected boolean firstElement;
    protected int lastNode;
    protected boolean startTagOpen;
    protected boolean children;
    private boolean cdataOutput;
    protected Stack stateStack = new Stack();
    protected NamespaceStack namespaceStack = new NamespaceStack();
    protected static final int XML_SPACE_DEFAULT = 0;
    protected static final int XML_SPACE_PRESERVE = 1;
    protected static final Integer xmlSpaceDefault = new Integer(0);
    protected static final Integer xmlSpacePreserve = new Integer(1);
    protected int xmlSpace = 0;

    public SAXWriter(Parser parser, InputSource inputSource, Writer writer) {
        this.parser = parser;
        this.inputSource = inputSource;
        this.writer = writer;
    }

    public SAXWriter(Parser parser, InputSource inputSource, OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.parser = parser;
        this.inputSource = inputSource;
        this.encoding = string;
        try {
            this.writer = new EncodingStreamWriter(outputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.writer = new OutputStreamWriter(outputStream, string);
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write() throws IOException {
        this.indentLevel = 0;
        try {
            this.parser.setDocumentHandler(this);
            this.parser.parse(this.inputSource);
            this.flush();
        }
        catch (SAXException sAXException) {
            this.flush();
            throw new IOException(sAXException.toString());
        }
    }

    public boolean getWriteDeclaration() {
        return this.writeDeclaration;
    }

    public void setWriteDeclaration(boolean bl) {
        this.writeDeclaration = bl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public boolean getIndent() {
        return this.indent;
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
    }

    public String getDoctypePublic() {
        return this.doctypePublic;
    }

    public void setDoctypePublic(String string) {
        this.doctypePublic = string;
    }

    public String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    public void setDoctypeSystem(String string) {
        this.doctypeSystem = string;
    }

    public boolean getDisableTextEscaping() {
        return this.disableTextEscaping;
    }

    public void setDisableTextEscaping(boolean bl) {
        this.disableTextEscaping = bl;
    }

    public Collection getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    public void setCdataSectionElements(Collection collection) {
        this.cdataSectionElements = collection;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        try {
            this.indentLevel = 0;
            this.firstElement = true;
            this.lastNode = -1;
            this.startTagOpen = false;
            this.children = false;
            this.cdataOutput = false;
            if (this.writeDeclaration) {
                this.writeDeclaration();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            if (this.firstElement && this.doctypeSystem != null && this.doctypeSystem.length() > 0) {
                this.writeDTD(string);
            }
            this.firstElement = false;
            this.children = true;
            this.pushState();
            this.closeStartTag();
            this.injectWhitespace(1);
            String string2 = attributeList.getValue("xml:space");
            if (string2 != null) {
                this.xmlSpace = string2.equals("preserve") ? 1 : 0;
            }
            this.cdataOutput = this.useCdataOutput(string);
            this.children = false;
            this.lastNode = 1;
            ++this.indentLevel;
            this.startTagOpen = true;
            this.writer.write(60);
            this.writer.write(string);
            int n = 0;
            while (n < attributeList.getLength()) {
                String string3 = attributeList.getName(n);
                this.writer.write(32);
                this.writer.write(string3);
                this.writer.write(61);
                String string4 = attributeList.getValue(n);
                XMLUtil.encodeAttribute(this.writer, string4);
                if (XMLUtil.isNamespaceDecl(string3)) {
                    String string5 = XMLUtil.getPrefix(string3);
                    String string6 = string5.length() > 0 ? XMLUtil.getLocalName(string3) : "";
                    String string7 = string4;
                    this.namespaceStack.add(string6, new NamespaceName(string7));
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        try {
            if (!this.children) {
                this.closeStartTag();
            } else {
                if (this.indent && this.xmlSpace != 1 && this.lastNode != 3) {
                    this.writer.write(10);
                    int n = 0;
                    while (n < this.indentLevel - 1) {
                        this.writer.write(9);
                        ++n;
                    }
                }
                this.writer.write("</");
                this.writer.write(string);
                this.writer.write(62);
            }
            --this.indentLevel;
            this.popState();
            this.lastNode = 1;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.children = true;
            this.closeStartTag();
            String string = new String(cArray, n, n2);
            if (this.cdataOutput) {
                XMLUtil.encodeAsCData(this.writer, string);
            } else if (this.disableTextEscaping) {
                this.writer.write(string);
            } else {
                XMLUtil.encodeText(this.writer, string);
            }
            this.lastNode = 3;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            if (string == null || string.length() == 0) {
                this.comment(string2);
            } else {
                this.children = true;
                this.closeStartTag();
                this.injectWhitespace(7);
                this.writer.write("<?");
                this.writer.write(string);
                if (string2 != null && string2.length() > 0) {
                    this.writer.write(32);
                    this.writer.write(string2);
                }
                this.writer.write("?>");
                this.lastNode = 7;
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void comment(String string) throws SAXException {
        try {
            this.children = true;
            this.closeStartTag();
            this.injectWhitespace(8);
            this.writer.write("<!--");
            this.writer.write(string);
            this.writer.write("-->");
            this.lastNode = 8;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void writeDeclaration() throws IOException {
        this.writer.write("<?xml version=\"1.0\"");
        if (this.encoding != null && this.encoding.length() > 0) {
            this.writer.write(" encoding=\"");
            this.writer.write(this.encoding);
            this.writer.write(34);
        }
        if (this.standalone) {
            this.writer.write(" standalone=\"yes\"");
        }
        this.writer.write("?>");
    }

    protected void writeDTD(String string) throws IOException {
        if (string == null || string.length() == 0) {
            return;
        }
        this.injectWhitespace(1);
        this.writer.write("<!DOCTYPE ");
        this.writer.write(string);
        if (this.doctypePublic != null && this.doctypePublic.length() > 0) {
            this.writer.write(" PUBLIC ");
            int n = this.doctypePublic.indexOf(34) >= 0 ? 39 : 34;
            this.writer.write(n);
            this.writer.write(this.doctypePublic);
            this.writer.write(n);
            this.writer.write(32);
            n = this.doctypeSystem.indexOf(34) >= 0 ? 39 : 34;
            this.writer.write(n);
            this.writer.write(this.doctypeSystem);
            this.writer.write(n);
        } else {
            this.writer.write(" SYSTEM ");
            int n = this.doctypeSystem.indexOf(34) >= 0 ? 39 : 34;
            this.writer.write(n);
            this.writer.write(this.doctypeSystem);
            this.writer.write(n);
        }
        this.writer.write(" >");
    }

    protected void injectWhitespace(int n) throws IOException {
        if (!this.indent || this.xmlSpace == 1) {
            return;
        }
        switch (n) {
            case 1: 
            case 7: 
            case 8: {
                if (this.lastNode == 3) break;
                this.writer.write(10);
                int n2 = 0;
                while (n2 < this.indentLevel) {
                    this.writer.write(9);
                    ++n2;
                }
                break;
            }
        }
    }

    protected void closeStartTag() throws IOException {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            if (this.children) {
                this.writer.write(62);
            } else {
                this.writer.write("/>");
            }
        }
    }

    protected boolean useCdataOutput(String string) {
        String string2;
        String string3;
        if (this.cdataSectionElements == null || this.cdataSectionElements.isEmpty()) {
            return false;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1, string.length());
        } else {
            string3 = "";
            string2 = string;
        }
        NamespaceName namespaceName = this.namespaceStack.getNamespaceName(string3);
        if (namespaceName == null) {
            return false;
        }
        return this.cdataSectionElements.contains(new ExpandedQName(namespaceName, string2, string3));
    }

    protected void pushState() {
        this.stateStack.push(this.children ? Boolean.TRUE : Boolean.FALSE);
        this.stateStack.push(this.cdataOutput ? Boolean.TRUE : Boolean.FALSE);
        this.stateStack.push(this.xmlSpace == 0 ? xmlSpaceDefault : xmlSpacePreserve);
        this.namespaceStack.push();
    }

    protected void popState() {
        this.namespaceStack.pop();
        this.xmlSpace = (Integer)this.stateStack.pop();
        this.cdataOutput = (Boolean)this.stateStack.pop();
        this.children = (Boolean)this.stateStack.pop();
    }
}

