/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.util;

import com.novell.util.StringCache;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.NamespaceName;
import java.util.TreeMap;
import org.w3c.dom.Node;

public class ExpandedQName
implements Comparable {
    public static final String UNKNOWN_NAMESPACE = "#{Unknown}#";
    private int local_part_number;
    private NamespaceName namespace_name;
    private int prefix_number = -1;
    int hash = 0;
    private static final int CACHE_INITIAL_SIZE = 8;
    private static final int LOCAL_CACHE_INITIAL_SIZE = 128;
    private static StringCache prefixCache = new StringCache(new TreeMap(), 8);
    private static StringCache localPartCache = new StringCache(new TreeMap(), 128);

    public ExpandedQName(String string, String string2) {
        this.namespace_name = new NamespaceName(string == null ? UNKNOWN_NAMESPACE : string);
        this.local_part_number = localPartCache.getNumber(string2);
    }

    public ExpandedQName(NamespaceName namespaceName, String string) {
        this.namespace_name = namespaceName;
        this.local_part_number = localPartCache.getNumber(string);
    }

    public ExpandedQName(Node node) {
        String string;
        String string2;
        String string3 = node.getNodeName();
        int n = string3.indexOf(58);
        if (n > 0) {
            string2 = string3.substring(0, n);
            this.prefix_number = prefixCache.getNumber(string2);
        } else {
            this.prefix_number = 0;
            string2 = "";
        }
        this.namespace_name = this.prefix_number == 0 && node.getNodeType() == 2 ? NamespaceName.NULL_NAMESPACE : ((string = DOMUtil.getURIforNSPrefix(string2, node)) == null ? (this.prefix_number != 0 ? new NamespaceName(UNKNOWN_NAMESPACE) : NamespaceName.NULL_NAMESPACE) : new NamespaceName(string));
        this.local_part_number = localPartCache.getNumber(n == -1 ? string3 : string3.substring(n + 1, string3.length()));
    }

    public ExpandedQName(String string, Node node) {
        String string2;
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
            this.prefix_number = prefixCache.getNumber(string2);
        } else {
            this.prefix_number = 0;
            string2 = "";
        }
        String string3 = DOMUtil.getURIforNSPrefix(string2, node);
        this.namespace_name = string3 == null ? NamespaceName.NULL_NAMESPACE : new NamespaceName(string3);
        this.local_part_number = localPartCache.getNumber(n == -1 ? string : string.substring(n + 1, string.length()));
    }

    public ExpandedQName(String string, String string2, Node node) {
        this.prefix_number = prefixCache.getNumber(string);
        String string3 = DOMUtil.getURIforNSPrefix(string, node);
        this.namespace_name = string3 == null ? NamespaceName.NULL_NAMESPACE : new NamespaceName(string3);
        this.local_part_number = localPartCache.getNumber(string2);
    }

    public ExpandedQName(String string, String string2, String string3) {
        this.prefix_number = prefixCache.getNumber(string3);
        this.namespace_name = new NamespaceName(string == null ? UNKNOWN_NAMESPACE : string);
        this.local_part_number = localPartCache.getNumber(string2);
    }

    public ExpandedQName(NamespaceName namespaceName, String string, String string2) {
        this.prefix_number = prefixCache.getNumber(string2);
        this.namespace_name = namespaceName;
        this.local_part_number = localPartCache.getNumber(string);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.namespace_name.hashCode() * this.local_part_number + this.local_part_number;
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        return object instanceof ExpandedQName && this.local_part_number == ((ExpandedQName)object).local_part_number && this.namespace_name.equals(((ExpandedQName)object).namespace_name);
    }

    public boolean equals(ExpandedQName expandedQName) {
        return this.local_part_number == expandedQName.local_part_number && this.namespace_name.equals(expandedQName.namespace_name);
    }

    public boolean namespaceNameEquals(ExpandedQName expandedQName) {
        return this.namespace_name.equals(expandedQName.namespace_name);
    }

    public boolean namespaceNameEquals(NamespaceName namespaceName) {
        return this.namespace_name.equals(namespaceName);
    }

    public boolean namespaceNameEquals(String string) {
        return string.equals(this.getNamespaceName());
    }

    public boolean localPartEquals(ExpandedQName expandedQName) {
        return this.local_part_number == expandedQName.local_part_number;
    }

    public boolean localPartEquals(String string) {
        return this.getLocalPart().equals(string);
    }

    public int compareTo(Object object) {
        if (!(object instanceof ExpandedQName)) {
            return -1;
        }
        int n = this.namespace_name.compareTo(((ExpandedQName)object).namespace_name);
        if (n != 0) {
            return n;
        }
        return this.getLocalPart().compareTo(((ExpandedQName)object).getLocalPart());
    }

    public String toString() {
        return this.namespace_name.getString() + this.getLocalPart();
    }

    public String getQName() {
        if (this.prefix_number != -1) {
            if (this.prefix_number == 0) {
                return this.getLocalPart();
            }
            return prefixCache.getString(this.prefix_number) + ":" + this.getLocalPart();
        }
        if (this.namespace_name.isEmpty()) {
            return this.getLocalPart();
        }
        return "{Unknown}:" + this.getLocalPart();
    }

    public NamespaceName getNamespaceName() {
        return this.namespace_name;
    }

    public String getNamespaceURI() {
        return this.namespace_name.getString();
    }

    public String getLocalPart() {
        return localPartCache.getString(this.local_part_number);
    }

    public String getPrefix() {
        return this.prefix_number == -1 ? null : prefixCache.getString(this.prefix_number);
    }
}

