/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public class ArgumentList {
    private Expression[] expressions;

    public ArgumentList(Expression[] expressionArray) {
        this.expressions = expressionArray;
    }

    public ArgumentList() {
        this.expressions = null;
    }

    public String toString() {
        if (this.expressions != null) {
            String string = this.expressions[0].toString();
            int n = 1;
            while (n < this.expressions.length) {
                string = string + "," + this.expressions[n].toString();
                ++n;
            }
            return string;
        }
        return "";
    }

    ExpressionValue[] evaluate(Node node, ExpressionContext expressionContext) throws XPathEvaluationException {
        ExpressionValue[] expressionValueArray = new ExpressionValue[this.expressions.length];
        int n = 0;
        while (n < this.expressions.length) {
            expressionValueArray[n] = this.expressions[n].evaluate(node, expressionContext);
            ++n;
        }
        return expressionValueArray;
    }

    public int count() {
        return this.expressions != null ? this.expressions.length : 0;
    }

    public Expression getArgument(int n) {
        return this.expressions != null ? this.expressions[n] : null;
    }
}

