/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.NodeTest;
import com.novell.xml.xpath.NodeTypeToken;
import org.w3c.dom.Node;

public class NodeType
implements NodeTest {
    private int type;

    public NodeType(NodeTypeToken nodeTypeToken) {
        this.type = nodeTypeToken.getNodeType();
    }

    public int getNodeType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "comment()";
            }
            case 2: {
                return "node()";
            }
            case 3: {
                return "processing-instruction()";
            }
            case 4: {
                return "text()";
            }
        }
        return "<unknown-node-type>";
    }

    protected NodeType(int n) {
        this.type = n;
    }

    public boolean evaluate(Node node) {
        switch (this.type) {
            case 1: {
                return node.getNodeType() == 8;
            }
            case 2: {
                return true;
            }
            case 3: {
                return node.getNodeType() == 7;
            }
            case 4: {
                short s = node.getNodeType();
                return s == 3 || s == 4;
            }
        }
        return false;
    }
}

