/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Binder;
import com.novell.xml.xpath.Token;

public class NodeTypeToken
extends Token {
    public static final int NOT_NODE_TYPE = 0;
    public static final int COMMENT = 1;
    public static final int NODE = 2;
    public static final int PI = 3;
    public static final int TEXT = 4;
    private int nodeType;
    private static final Binder[] BINDER = new Binder[]{new Binder(1, "comment"), new Binder(2, "node"), new Binder(3, "processing-instruction"), new Binder(4, "text")};

    public NodeTypeToken(int n) {
        super(12);
        this.nodeType = n;
    }

    public boolean equals(Token token) {
        return super.equals(token) && this.getNodeType() == ((NodeTypeToken)token).getNodeType();
    }

    public String toString() {
        return super.toString() + "{" + NodeTypeToken.getTypeName(this.getNodeType()) + "}";
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public static String getTypeName(int n) {
        if (n < 1 || n > 4) {
            return "";
        }
        return NodeTypeToken.BINDER[n - 1].text;
    }

    public static int getTypeFromName(String string) {
        int n = 0;
        while (n < 4) {
            if (string.equals(NodeTypeToken.BINDER[n].text)) {
                return NodeTypeToken.BINDER[n].id;
            }
            ++n;
        }
        return 0;
    }
}

