/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.xpath;

import com.novell.xml.xpath.Basis;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.Predicate;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Node;

public class Step {
    private Basis basis;
    private Predicate[] predicates = null;
    private ExpressionContext context;
    private ContextNodeList list;

    public Step(Basis basis) {
        this.basis = basis;
    }

    public Step(Basis basis, Predicate predicate) {
        this.basis = basis;
        this.predicates = new Predicate[1];
        this.predicates[0] = predicate;
    }

    public Step(Basis basis, Predicate[] predicateArray) {
        this.basis = basis;
        this.predicates = predicateArray;
    }

    public Step(Step step, Predicate predicate) {
        this.basis = step.basis;
        if (step.predicates != null) {
            this.predicates = new Predicate[step.predicates.length + 1];
            int n = 0;
            while (n < step.predicates.length) {
                this.predicates[n] = step.predicates[n];
                ++n;
            }
            this.predicates[n] = predicate;
        } else {
            this.predicates = new Predicate[1];
            this.predicates[0] = predicate;
        }
    }

    public void setup(Node node, ExpressionContext expressionContext) {
        this.context = expressionContext;
        this.basis.setup(node, expressionContext);
        if (this.predicates != null && this.predicates.length > 0) {
            expressionContext.pushState();
            expressionContext.setContextNodeList(this.basis);
            this.predicates[0].setup(expressionContext);
            int n = 1;
            while (n < this.predicates.length) {
                ExpressionContext expressionContext2 = new ExpressionContext(expressionContext);
                expressionContext2.setContextNodeList(this.predicates[n - 1]);
                this.predicates[n].setup(expressionContext2);
                ++n;
            }
            this.list = this.predicates[this.predicates.length - 1];
        } else {
            this.list = this.basis;
        }
    }

    public void done() {
        if (this.context != null && this.predicates != null && this.predicates.length > 0) {
            this.context.popState();
        }
        if (this.predicates != null && this.predicates.length > 0) {
            int n = 0;
            while (n < this.predicates.length) {
                this.predicates[n].done();
                ++n;
            }
        }
        this.list = null;
        this.context = null;
        this.basis.done();
    }

    public Node first() throws XPathEvaluationException {
        if (this.list == null) {
            return null;
        }
        return this.list.first();
    }

    public Node next() throws XPathEvaluationException {
        if (this.list == null) {
            return null;
        }
        return this.list.next();
    }

    public String toString() {
        String string = this.basis.toString();
        if (this.predicates != null) {
            int n = 0;
            while (n < this.predicates.length) {
                string = string + this.predicates[n].toString();
                ++n;
            }
        }
        return string;
    }
}

