/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.debug;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.Rule;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public final class Trace {
    public static final boolean ENABLED = true;
    public static final int TRACE_OFF = 0;
    public static final int TRACE_SOURCE_PROCESSING = 1;
    public static final int TRACE_RULE_INSTANTIATIONS = 2;
    public static final int TRACE_TEMPLATE_INSTANTIATIONS = 3;
    public static final int TRACE_RULE_MATCHING = 4;
    private static PrintWriter printWriter = null;
    private static int traceLevel = 0;

    private Trace() {
    }

    public static void setPrintWriter(PrintWriter printWriter) {
        Trace.printWriter = printWriter;
    }

    public static int getTraceLevel() {
        return traceLevel;
    }

    public static void setTraceLevel(int n) {
        if (printWriter == null) {
            throw new IllegalStateException("PrintWriter is not set");
        }
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("illegal trace level: " + n);
        }
        traceLevel = n;
    }

    public static void traceSource(Node node, Mode mode) {
        if (traceLevel >= 1) {
            printWriter.print("Processing source node ");
            printWriter.print(XPathUtil.describeNode(node));
            if (mode != Mode.DEFAULT_MODE) {
                printWriter.print(" mode=");
                printWriter.print(mode.getName());
            }
            printWriter.println();
        }
    }

    public static void traceRuleBegin(Rule rule) {
        if (traceLevel >= 4) {
            printWriter.print("   Testing rule (" + rule.getNumber() + ") pattern=\"" + rule.getPattern().toString() + "\" :");
            printWriter.flush();
        }
    }

    public static void traceRuleEnd(Rule rule) {
        if (traceLevel >= 4) {
            printWriter.println();
            printWriter.flush();
        }
        if (traceLevel >= 2 && rule != null) {
            printWriter.println("   Instantiating rule " + rule.getNumber());
            printWriter.flush();
        }
    }

    public static void traceRuleBuiltIn(Rule rule) {
        if (traceLevel >= 2) {
            if (rule != null) {
                Trace.traceRuleBegin(rule);
                if (traceLevel >= 4) {
                    printWriter.print(" builtin+");
                }
                Trace.traceRuleEnd(rule);
            } else if (traceLevel >= 4) {
                printWriter.println("   NO MATCHING RULE");
            }
        }
    }

    public static void traceTemplate(String string) {
        Trace.traceTemplate(string, Mode.DEFAULT_MODE);
    }

    public static void traceTemplate(String string, Mode mode) {
        if (traceLevel >= 3) {
            printWriter.print("      Instantiating ");
            printWriter.print(string);
            if (mode != Mode.DEFAULT_MODE) {
                printWriter.print(" mode=");
                printWriter.print(mode.getName());
            }
            printWriter.println();
        }
    }

    public static void traceMatch(String string) {
        if (traceLevel >= 4) {
            printWriter.print(string);
        }
    }

    public static void traceSelect(Expression expression, ExpressionValue expressionValue) {
        if (traceLevel >= 4) {
            printWriter.println("      Select expression: \"" + expression.toString() + "\"");
            printWriter.print("      Result: ");
            expressionValue.dump(printWriter);
            printWriter.println();
        }
    }

    public static void traceSortKey(String string) {
        if (traceLevel >= 4) {
            printWriter.print("Sort key: ");
            printWriter.println(string);
        }
    }
}

