/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.extensions;

import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Function;
import com.novell.xml.xpath.FunctionLibraryImpl;
import com.novell.xml.xpath.FunctionSignature;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.functions.XPathBuiltIns;
import com.novell.xsl.extensions.BadFunction;
import com.novell.xsl.extensions.JavaConstructor;
import com.novell.xsl.extensions.JavaMethod;
import com.novell.xsl.extensions.functions.NxslBuiltIns;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ExtensibleFunctionLibrary
extends FunctionLibraryImpl {
    protected ClassLoader loader = null;

    public ExtensibleFunctionLibrary() {
        XPathBuiltIns.addBuiltIns(this);
        NxslBuiltIns.addBuiltIns(this);
    }

    public ExtensibleFunctionLibrary(ClassLoader classLoader) {
        XPathBuiltIns.addBuiltIns(this);
        NxslBuiltIns.addBuiltIns(this);
        this.loader = classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public Function getFunction(ExpandedQName expandedQName) throws XPathParserException {
        Function function = this.findFunction(expandedQName);
        if (function != null) {
            return function;
        }
        try {
            String string = expandedQName.getNamespaceURI();
            if (string.startsWith("http://www.novell.com/nxsl/java/")) {
                String string2 = string.substring("http://www.novell.com/nxsl/java/".length(), string.length());
                Class<?> clazz = this.loader == null ? Class.forName(string2) : this.loader.loadClass(string2);
                String string3 = expandedQName.getLocalPart();
                if (string3.equals("new")) {
                    Constructor[] constructorArray = clazz.getConstructors();
                    if (constructorArray.length != 0) {
                        function = this.doConstructors(constructorArray, expandedQName, clazz);
                    }
                } else {
                    Method[] methodArray = clazz.getMethods();
                    if (methodArray.length != 0) {
                        function = this.doMethods(methodArray, expandedQName, clazz);
                    }
                }
                if (function != null) {
                    this.addFunction(function);
                    return function;
                }
                return super.getFunction(expandedQName);
            }
            if (expandedQName.getPrefix() != null && expandedQName.getPrefix().length() > 0) {
                try {
                    throw new XPathParserException("pe12", expandedQName.getQName());
                }
                catch (XPathParserException xPathParserException) {
                    return new BadFunction(xPathParserException.getMessage());
                }
            }
            throw new XPathParserException("pe12", expandedQName.getQName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                throw new XPathParserException("pe12", expandedQName.getQName());
            }
            catch (XPathParserException xPathParserException) {
                function = new BadFunction(xPathParserException.getMessage());
                return function;
            }
        }
    }

    private Function doConstructors(Constructor[] constructorArray, ExpandedQName expandedQName, Class clazz) {
        FunctionSignature functionSignature = new FunctionSignature(expandedQName, clazz);
        return new JavaConstructor(functionSignature, constructorArray);
    }

    private Function doMethods(Method[] methodArray, ExpandedQName expandedQName, Class clazz) {
        String string = expandedQName.getLocalPart();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        int n = 0;
        while (n < methodArray.length) {
            if (string.equals(methodArray[n].getName())) {
                arrayList.add(methodArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        methodArray = new Method[arrayList.size()];
        arrayList.toArray(methodArray);
        Class<?> clazz2 = methodArray[0].getReturnType();
        FunctionSignature functionSignature = new FunctionSignature(expandedQName, clazz2);
        return new JavaMethod(functionSignature, methodArray, clazz);
    }
}

