/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl;

import com.novell.io.EncodingStreamWriter;
import com.novell.util.URIResolver;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.parser.SAXParserImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.sax.SAXWriter;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.util.XmlWriter;
import com.novell.xsl.DefaultErrorHandler;
import com.novell.xsl.DefaultMessageHandler;
import com.novell.xsl.SAXtoDOMStrip;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.result.DOMResultHandler;
import com.novell.xsl.result.SAXResultHandler;
import com.novell.xsl.result.SerializerOptions;
import com.novell.xsl.util.Timer;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;

public class nxsl {
    private static final int TIMES_SOURCE_PARSE = 0;
    private static final int TIMES_XSL_PARSE = 1;
    private static final int TIMES_COMPILE = 2;
    private static final int TIMES_PROCESS = 3;
    private static final int TIMES_TOTAL = 4;
    private static final int TIMES_ARRAY_SIZE = 5;
    private static final int USAGE_MESSAGE_COUNT = 17;
    private static final String STYLESHEET_REQUIRED = "e1";
    private static final String PARSE_ERRORS = "e2";
    private static final String TOO_MANY_FILENAMES = "e3";
    private static final String FILENAME_REQUIRED = "e4";
    private static final String VERSION_MSG = "e5";
    private static final String UNRECOGNIZED_OPTION = "e6";
    private static final String SOURCE_DOC_REQUIRED = "e7";
    private static final String BAD_P_SYNTAX = "e8";
    private static final String DOM2_NAMESPACES = "e9";
    private static final String TIMER_HEADER = "tm1";
    private static final String TIMER_PARSE = "tm2";
    private static final String TIMER_COMPILE = "tm3";
    private static final String TIMER_PROCESS = "tm4";
    private static final String TIMER_TOTAL = "tm5";
    boolean dumpStylesheet = false;
    int traceLevel = 0;
    boolean suppressErrors = false;
    boolean redirectErrors = false;
    boolean suppressWarnings = false;
    boolean printTimes = false;
    boolean forceDOM = false;
    boolean forceSAX = false;
    String xmlFilename = null;
    String xslFilename = null;
    String resultFilename = null;
    List stylesheetParms = null;
    long[] times = null;
    Timer timer = null;
    XMLParser xmlParser;
    Stylesheet stylesheet = null;
    boolean alreadyStripped = false;
    boolean waitForDebugger = false;
    boolean brokenMode = false;

    public static void main(String[] stringArray) {
        nxsl nxsl2 = new nxsl();
        nxsl2.instanceMain(stringArray);
    }

    private void instanceMain(String[] stringArray) {
        this.xmlParser = new SAXParserImpl();
        try {
            PrintWriter printWriter;
            OutputStream outputStream;
            this.parseCommandLine(stringArray);
            if (this.redirectErrors) {
                System.setErr(System.out);
            }
            if (this.waitForDebugger) {
                System.out.println("Press enter to continue");
                try {
                    System.in.read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.printTimes) {
                this.times = new long[5];
                this.timer = new Timer();
            }
            if (this.xslFilename != null) {
                this.constructStylesheet(this.xslFilename);
            }
            Document document = null;
            if (!this.forceSAX) {
                document = this.constructSource(this.xmlFilename);
            }
            if (this.xslFilename == null && document != null) {
                this.stylesheet = new Stylesheet();
                this.stylesheet.setBrokenMode(this.brokenMode);
                this.stylesheet.loadFromSource(document, this.xmlFilename);
                if (!this.stylesheet.isLoaded()) {
                    nxsl.commandLineError(STYLESHEET_REQUIRED, null);
                }
            }
            if (this.traceLevel != 0) {
                Trace.setPrintWriter(new PrintWriter(System.err, true));
                Trace.setTraceLevel(this.traceLevel);
            }
            if (this.resultFilename == null) {
                outputStream = System.out;
                printWriter = new PrintWriter(outputStream);
            } else {
                outputStream = new FileOutputStream(this.resultFilename);
                printWriter = new PrintWriter(new BufferedOutputStream(outputStream));
            }
            if (this.dumpStylesheet) {
                this.stylesheet.dump(printWriter);
            } else {
                Writer writer;
                String[] stringArray2;
                SerializerOptions serializerOptions;
                Object object;
                Object object2;
                if (this.stylesheetParms != null) {
                    object2 = this.stylesheetParms.iterator();
                    while (object2.hasNext()) {
                        object = (StylesheetParm)object2.next();
                        this.stylesheet.setParameter(((StylesheetParm)object).getQName(), ((StylesheetParm)object).getExpression());
                    }
                }
                if (this.forceDOM) {
                    this.stylesheet.setResultHandler(new DOMResultHandler(DocumentFactory.newDocument()));
                } else if (this.forceSAX) {
                    object2 = new SAXResultHandler(this.stylesheet);
                    object = new InputSource(this.xmlFilename);
                    serializerOptions = this.stylesheet.getSerializerOptions();
                    stringArray2 = new String[1];
                    writer = this.setupOutputWriter(stringArray2, serializerOptions, outputStream);
                    SAXWriter sAXWriter = new SAXWriter((Parser)object2, (InputSource)object, writer);
                    this.setupXmlWriter(sAXWriter, stringArray2[0], serializerOptions);
                    ((SAXResultHandler)object2).setDocumentHandler(sAXWriter);
                    sAXWriter.write();
                    sAXWriter.flush();
                } else {
                    this.stylesheet.setSerializerStream(outputStream);
                }
                if (!this.forceSAX) {
                    this.stylesheet.process(document, new URL(this.xmlFilename), this.alreadyStripped);
                }
                if (this.printTimes) {
                    this.times[3] = this.timer.getLapTime();
                }
                if (this.forceDOM) {
                    object2 = ((DOMResultHandler)this.stylesheet.getResultHandler()).getDocument();
                    if (!this.suppressErrors && !DOMUtil.checkNamespacesAgree((Node)object2)) {
                        nxsl.showError(DOM2_NAMESPACES);
                    }
                    serializerOptions = this.stylesheet.getSerializerOptions();
                    stringArray2 = new String[1];
                    writer = this.setupOutputWriter(stringArray2, serializerOptions, outputStream);
                    object = new DOMWriter((Node)object2, writer);
                    this.setupXmlWriter((XmlWriter)object, stringArray2[0], serializerOptions);
                    ((DOMWriter)object).write();
                    ((DOMWriter)object).flush();
                }
                if (this.printTimes) {
                    this.times[4] = this.timer.getTotalTime();
                    nxsl.showMessage(TIMER_HEADER, null);
                    nxsl.showMessage(TIMER_PARSE, new String[]{this.timer.millisToString(this.times[0]), this.xmlFilename});
                    nxsl.showMessage(TIMER_PARSE, new String[]{this.timer.millisToString(this.times[1]), this.xslFilename});
                    nxsl.showMessage(TIMER_COMPILE, new String[]{this.timer.millisToString(this.times[2])});
                    nxsl.showMessage(TIMER_PROCESS, new String[]{this.timer.millisToString(this.times[3])});
                    nxsl.showMessage(TIMER_TOTAL, new String[]{this.timer.millisToString(this.times[4])});
                }
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        catch (XSLException xSLException) {
            if (xSLException.isError()) {
                System.out.println(xSLException);
            }
            System.out.println(xSLException.getMessage());
        }
    }

    private Document constructSource(String string) throws IOException {
        if (this.stylesheet != null) {
            ((SAXParserImpl)this.xmlParser).setConverter(new SAXtoDOMStrip(DocumentImpl.newDocument(), this.stylesheet.getStripList()));
            this.alreadyStripped = true;
        }
        Document document = this.xmlParser.parse(string);
        if (this.printTimes) {
            this.times[0] = this.timer.getLapTime();
        }
        if (this.xmlParser.anyErrors()) {
            nxsl.showError(PARSE_ERRORS, string);
            this.xmlParser.reportErrorMsgs(System.err);
            System.exit(1);
        }
        if (this.stylesheet != null) {
            ((SAXParserImpl)this.xmlParser).setConverter(null);
        }
        return document;
    }

    private void constructStylesheet(String string) throws XSLException, IOException {
        Document document = this.xmlParser.parse(string);
        if (this.printTimes) {
            this.times[1] = this.timer.getLapTime();
        }
        if (this.xmlParser.anyErrors()) {
            nxsl.showError(PARSE_ERRORS, string);
            this.xmlParser.reportErrorMsgs(System.out);
            System.exit(1);
        }
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        defaultErrorHandler.setLogErrors(!this.suppressErrors);
        defaultErrorHandler.setLogWarnings(!this.suppressWarnings);
        DefaultMessageHandler defaultMessageHandler = new DefaultMessageHandler();
        this.stylesheet = new Stylesheet();
        this.stylesheet.setBrokenMode(this.brokenMode);
        this.stylesheet.setErrorHandler(defaultErrorHandler);
        this.stylesheet.setMessageHandler(defaultMessageHandler);
        if (document != null) {
            this.stylesheet.setBaseURI(string);
            this.stylesheet.load(document);
        }
        if (this.printTimes) {
            this.times[2] = this.timer.getLapTime();
        }
    }

    private Writer setupOutputWriter(String[] stringArray, SerializerOptions serializerOptions, OutputStream outputStream) throws UnsupportedEncodingException {
        Writer writer;
        try {
            if (serializerOptions != null && serializerOptions.getEncoding() != null && serializerOptions.getEncoding().length() > 0) {
                try {
                    writer = new EncodingStreamWriter(outputStream, serializerOptions.getEncoding());
                    stringArray[0] = ((EncodingStreamWriter)writer).getEncoding();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    writer = new OutputStreamWriter(outputStream, serializerOptions.getEncoding());
                    stringArray[0] = ((OutputStreamWriter)writer).getEncoding();
                }
            } else {
                writer = new EncodingStreamWriter(outputStream, "UTF-8");
                stringArray[0] = ((EncodingStreamWriter)writer).getEncoding();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            writer = new EncodingStreamWriter(outputStream, "UTF-8");
            stringArray[0] = ((EncodingStreamWriter)writer).getEncoding();
        }
        return writer;
    }

    private void setupXmlWriter(XmlWriter xmlWriter, String string, SerializerOptions serializerOptions) {
        xmlWriter.setEncoding(string);
        if (serializerOptions != null) {
            xmlWriter.setWriteDeclaration(serializerOptions.getDeclaration());
            xmlWriter.setIndent(serializerOptions.getIndent());
            xmlWriter.setStandalone(serializerOptions.getStandalone());
            xmlWriter.setDoctypeSystem(serializerOptions.getDoctypeSystem());
            xmlWriter.setDoctypePublic(serializerOptions.getDoctypePublic());
            xmlWriter.setCdataSectionElements(serializerOptions.getCdataSectionElements());
        }
    }

    private void parseCommandLine(String[] stringArray) throws MalformedURLException {
        int[] nArray = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '-') {
                if (this.xmlFilename == null) {
                    this.xmlFilename = stringArray[n];
                } else if (this.xslFilename == null) {
                    this.xslFilename = stringArray[n];
                } else {
                    nxsl.commandLineError(TOO_MANY_FILENAMES, null);
                }
            } else if (stringArray[n].equals("-d")) {
                this.dumpStylesheet = true;
            } else if (stringArray[n].equals("-d1")) {
                this.traceLevel = 1;
            } else if (stringArray[n].equals("-d2")) {
                this.traceLevel = 2;
            } else if (stringArray[n].equals("-d3")) {
                this.traceLevel = 3;
            } else if (stringArray[n].equals("-d4")) {
                this.traceLevel = 4;
            } else if (stringArray[n].equals("-debug")) {
                this.waitForDebugger = true;
            } else if (stringArray[n].equals("-e")) {
                this.suppressErrors = true;
            } else if (stringArray[n].equals("-e1")) {
                this.redirectErrors = true;
            } else if (stringArray[n].equals("-o")) {
                if (n < stringArray.length) {
                    this.resultFilename = stringArray[++n];
                } else {
                    nxsl.commandLineError(FILENAME_REQUIRED, null);
                }
            } else if (stringArray[n].equals("-p")) {
                if (this.stylesheetParms == null) {
                    this.stylesheetParms = new ArrayList();
                    nArray = new int[]{n};
                }
                try {
                    this.stylesheetParms.add(nxsl.parseStylesheetParm(stringArray, nArray));
                }
                catch (XSLException xSLException) {
                    nxsl.commandLineError(xSLException.getMessage(), null);
                }
                n = nArray[0];
            } else if (stringArray[n].equals("-r")) {
                if (n + 1 >= stringArray.length) {
                    nxsl.commandLineError(null, null);
                }
                if (stringArray[++n].equals("DOM")) {
                    this.forceDOM = true;
                } else if (stringArray[n].equals("SAX")) {
                    this.forceSAX = true;
                }
            } else if (stringArray[n].equals("-t")) {
                this.printTimes = true;
            } else if (stringArray[n].equals("-v")) {
                nxsl.showMessage(VERSION_MSG, new String[]{"Novell XSLT Processor", "2.00.10"});
                System.exit(0);
            } else if (stringArray[n].equals("-w")) {
                this.suppressWarnings = true;
            } else if (stringArray[n].equals("-usebroken")) {
                this.brokenMode = true;
            } else {
                nxsl.commandLineError(UNRECOGNIZED_OPTION, new String[]{stringArray[n]});
            }
            ++n;
        }
        if (stringArray.length == 0) {
            nxsl.commandLineError(null, null);
        } else if (this.xmlFilename == null) {
            nxsl.commandLineError(SOURCE_DOC_REQUIRED, null);
        }
        String string = XMLUtil.filenameToURL(".").toString().toString();
        this.xmlFilename = URIResolver.resolveURI(this.xmlFilename, string);
        if (this.xslFilename != null) {
            this.xslFilename = URIResolver.resolveURI(this.xslFilename, string);
        }
    }

    private static StylesheetParm parseStylesheetParm(String[] stringArray, int[] nArray) throws XSLException {
        try {
            int n = nArray[0];
            int n2 = ++n;
            String string = stringArray[n2];
            String string2 = stringArray[++n];
            nArray[0] = n;
            return new StylesheetParm(string, string2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XSLException("Bad -p syntax");
        }
    }

    private static void commandLineError(String string, Object[] objectArray) {
        if (string != null) {
            System.err.println(nxsl.constructMessage(string, objectArray));
        }
        String string2 = "u";
        int n = 1;
        while (n <= 17) {
            String string3 = string2 + n;
            System.err.println(nxsl.constructMessage(string3, null));
            ++n;
        }
        System.exit(1);
    }

    public static void showError(String string) {
        System.err.println(nxsl.constructMessage(string, null));
    }

    public static void showError(String string, String string2) {
        System.err.println(nxsl.constructMessage(string, new String[]{string2}));
    }

    public static void showMessage(String string, Object[] objectArray) {
        System.out.println(nxsl.constructMessage(string, objectArray));
    }

    public static String constructMessage(String string, Object[] objectArray) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.novell.xsl.nxsl_messages");
        try {
            string = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        return objectArray == null ? string : MessageFormat.format(string, objectArray);
    }

    private static class StylesheetParm {
        private String qName;
        private String expString;

        public StylesheetParm(String string, String string2) {
            this.qName = string;
            this.expString = string2;
        }

        public String getQName() {
            return this.qName;
        }

        public String getExpression() {
            return this.expString;
        }
    }
}

