/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.parser;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.Token;
import com.novell.xml.xpath.VariableReference;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.debug.Assert;
import com.novell.xsl.parser.AVT;
import com.novell.xsl.parser.StylesheetParser;
import com.novell.xsl.parser.XSLTParserException;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.Priority;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttrDef {
    public static final int OPTIONAL = 0;
    public static final int REQUIRED = 1;
    public static final int AVT_EXPR = 0;
    public static final int ENUM = 1;
    public static final int TOP_PATTERN = 2;
    public static final int PATTERN = 3;
    public static final int MODE = 4;
    public static final int NAME = 5;
    public static final int QNAME = 6;
    public static final int PRIORITY = 7;
    public static final int SELECT_EXPR = 8;
    public static final int STRING = 9;
    public static final int TOP_EXPR = 10;
    public static final int EXPR = 11;
    public static final int CHAR = 12;
    private static final Integer[] INTEGERS = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
    private String name;
    private int optOrReq;
    private Object defaultValue;
    private int type;
    private String[] legalValues;

    public AttrDef(String string, int n, Object object, int n2) {
        this.name = string;
        this.optOrReq = n;
        this.defaultValue = object;
        this.type = n2;
    }

    public AttrDef(String string, int n, int n2, String[] stringArray) {
        this.name = string;
        this.optOrReq = n;
        this.type = 1;
        this.defaultValue = n2 != -1 ? INTEGERS[n2] : null;
        this.legalValues = stringArray;
        Assert.assertCondition(stringArray.length <= INTEGERS.length, "INTEGERS[] needs to be bigger");
    }

    public boolean isRequired() {
        return this.optOrReq == 1;
    }

    public static Object[] parseAttributes(StylesheetParser stylesheetParser, Element element, AttrDef[] attrDefArray) throws XSLTParserException {
        int n;
        Token[] tokenArray;
        String string;
        Object[] objectArray = new Object[attrDefArray.length];
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = 0;
        while (n2 < namedNodeMap.getLength()) {
            Node node = namedNodeMap.item(n2);
            string = node.getNodeName();
            if (!string.startsWith("xmlns") && ((tokenArray = DOMUtil.getNamespaceName(node)) == null || tokenArray.isEmpty() || tokenArray.equals(Stylesheet.NAMESPACE) && !tokenArray.equals(NamespaceName.XML_NAMESPACE))) {
                n = 0;
                while (n < attrDefArray.length) {
                    if (string.equals(attrDefArray[n].name)) {
                        objectArray[n] = node.getNodeValue();
                        break;
                    }
                    ++n;
                }
                if (n >= attrDefArray.length && !stylesheetParser.isForwardsCompatibleMode()) {
                    stylesheetParser.reportError(node, "spe6", node.getNodeName());
                }
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            string = (String)objectArray[n3];
            objectArray[n3] = attrDefArray[n3].defaultValue;
            if (string == null) {
                if (attrDefArray[n3].optOrReq == 1) {
                    stylesheetParser.reportError((Node)element, "spe5", attrDefArray[n3].name);
                }
            } else {
                switch (attrDefArray[n3].type) {
                    case 0: {
                        try {
                            objectArray[n3] = AVT.parse(string, stylesheetParser.getXPathParser(), stylesheetParser.getStylesheet().getErrorHandler());
                            ((Expression)objectArray[n3]).registerForReset(stylesheetParser.getStylesheet());
                        }
                        catch (XPathParserException xPathParserException) {
                            objectArray[n3] = stylesheetParser.reportAttributeExpressionError(element, attrDefArray[n3].name, xPathParserException);
                        }
                        break;
                    }
                    case 12: {
                        if (string.length() != 1) {
                            stylesheetParser.reportInvalidAttributeValue(element, attrDefArray[n3].name, attrDefArray[n3].isRequired(), XMLUtil.quote(string));
                            break;
                        }
                        objectArray[n3] = new Character(string.charAt(0));
                        break;
                    }
                    case 1: {
                        int n4 = 0;
                        while (n4 < attrDefArray[n3].legalValues.length) {
                            if (string.equals(attrDefArray[n3].legalValues[n4])) {
                                objectArray[n3] = INTEGERS[n4];
                                break;
                            }
                            ++n4;
                        }
                        if (n4 < attrDefArray[n3].legalValues.length) break;
                        stylesheetParser.reportInvalidAttributeValue(element, attrDefArray[n3].name, attrDefArray[n3].isRequired(), XMLUtil.quote(string));
                        break;
                    }
                    case 10: {
                        try {
                            stylesheetParser.getXPathParser().tokenize(string);
                            tokenArray = stylesheetParser.getXPathParser().getTokens();
                            n = 0;
                            while (n < tokenArray.length) {
                                if (tokenArray[n].getType() == 17) {
                                    throw new XPathParserException(XSLTParserException.constructMessage("spe21", null));
                                }
                                ++n;
                            }
                            objectArray[n3] = stylesheetParser.getXPathParser().parse(tokenArray);
                            ((Expression)objectArray[n3]).registerForReset(stylesheetParser.getStylesheet());
                        }
                        catch (XPathParserException xPathParserException) {
                            objectArray[n3] = stylesheetParser.reportAttributeExpressionError(element, attrDefArray[n3].name, xPathParserException);
                        }
                        break;
                    }
                    case 11: {
                        try {
                            objectArray[n3] = stylesheetParser.getXPathParser().parse(string);
                            ((Expression)objectArray[n3]).registerForReset(stylesheetParser.getStylesheet());
                        }
                        catch (XPathParserException xPathParserException) {
                            objectArray[n3] = stylesheetParser.reportAttributeExpressionError(element, attrDefArray[n3].name, xPathParserException);
                        }
                        break;
                    }
                    case 2: 
                    case 3: {
                        try {
                            objectArray[n3] = stylesheetParser.getPatternParser().parsePattern(string, attrDefArray[n3].type == 2);
                        }
                        catch (XPathParserException xPathParserException) {
                            objectArray[n3] = stylesheetParser.reportAttributeExpressionError(element, attrDefArray[n3].name, xPathParserException);
                        }
                        break;
                    }
                    case 4: {
                        if (XMLUtil.isQName(string)) {
                            tokenArray = stylesheetParser.getExpandedName(string);
                            objectArray[n3] = Mode.create((ExpandedQName)tokenArray);
                            break;
                        }
                        stylesheetParser.reportInvalidAttributeValue(element, attrDefArray[n3].name, attrDefArray[n3].isRequired(), XMLUtil.quote(string));
                        break;
                    }
                    case 5: {
                        if (XMLUtil.isXMLName(string)) {
                            objectArray[n3] = string;
                        } else {
                            stylesheetParser.reportInvalidAttributeValue(element, attrDefArray[n3].name, attrDefArray[n3].isRequired(), XMLUtil.quote(string));
                        }
                    }
                    case 6: {
                        if (XMLUtil.isQName(string)) {
                            objectArray[n3] = stylesheetParser.getExpandedName(string);
                            break;
                        }
                        stylesheetParser.reportInvalidAttributeValue(element, attrDefArray[n3].name, attrDefArray[n3].isRequired(), XMLUtil.quote(string));
                        break;
                    }
                    case 7: {
                        try {
                            objectArray[n3] = Priority.create(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            stylesheetParser.reportInvalidAttributeValue(element, attrDefArray[n3].name, attrDefArray[n3].isRequired(), XMLUtil.quote(string));
                        }
                        break;
                    }
                    case 8: {
                        try {
                            objectArray[n3] = stylesheetParser.getXPathParser().parse(string);
                            ((Expression)objectArray[n3]).registerForReset(stylesheetParser.getStylesheet());
                            if (((Expression)objectArray[n3]).getResultType() == NodeSet.getArgType() || objectArray[n3] instanceof VariableReference) break;
                            stylesheetParser.reportError((Node)element, "spe16", attrDefArray[n3].name);
                        }
                        catch (XPathParserException xPathParserException) {
                            objectArray[n3] = stylesheetParser.reportAttributeExpressionError(element, attrDefArray[n3].name, xPathParserException);
                        }
                        break;
                    }
                    case 9: {
                        objectArray[n3] = string;
                        break;
                    }
                    default: {
                        stylesheetParser.reportError(element, "internal error: unknown attribute type");
                    }
                }
            }
            ++n3;
        }
        return objectArray;
    }
}

