/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisChild;
import com.novell.xml.xpath.ContextNodeList;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.Mode;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.SortCriteria;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class ApplyTemplatesTemplate
implements Template {
    private final Expression select;
    private Mode mode;
    private final SortCriteria sortCriteria;
    private final Template[] params;
    private final Node nsContext;

    public ApplyTemplatesTemplate(Mode mode, Node node) {
        this.select = null;
        this.mode = mode;
        this.sortCriteria = null;
        this.params = null;
        this.nsContext = node;
    }

    public ApplyTemplatesTemplate(Expression expression, Mode mode, SortCriteria sortCriteria, Template[] templateArray, Node node) {
        this.select = expression;
        this.mode = mode;
        this.sortCriteria = sortCriteria;
        this.params = templateArray;
        this.nsContext = node;
    }

    public Expression getSelect() {
        return this.select;
    }

    public Mode getMode() {
        return this.mode;
    }

    public SortCriteria getSortCriteria() {
        return this.sortCriteria;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("apply-templates", this.mode);
        if (this.select == null && !node.hasChildNodes() || node.getNodeType() == 2) {
            return;
        }
        processingEnv.getContext().pushState();
        try {
            processingEnv.pushParameters();
            processingEnv.pushVariables();
            try {
                try {
                    ContextNodeList contextNodeList;
                    if (this.params != null) {
                        int n = 0;
                        while (n < this.params.length) {
                            processingEnv.getContext().setNamespaceContext(this.params[n].getNamespaceContext());
                            this.params[n].instantiate(processingEnv, node, resultHandler);
                            ++n;
                        }
                    }
                    if (this.select != null) {
                        processingEnv.getContext().setNamespaceContext(this.getNamespaceContext());
                        contextNodeList = processingEnv.getContext().evaluate(node, this.select).getNodeSetValue();
                        Trace.traceSelect(this.select, (ExpressionValue)((Object)contextNodeList));
                    } else {
                        contextNodeList = new AxisChild();
                        ((Axis)contextNodeList).setup(node, processingEnv.getContext());
                    }
                    if (this.sortCriteria != null) {
                        contextNodeList = this.sortCriteria.sort(processingEnv, node, contextNodeList);
                    }
                    processingEnv.getContext().setContextNodeList(contextNodeList);
                    Node node2 = contextNodeList.first();
                    while (node2 != null) {
                        processingEnv.process(node2, this.mode, resultHandler);
                        node2 = contextNodeList.next();
                    }
                }
                catch (XPathEvaluationException xPathEvaluationException) {
                    processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
                    Object var7_9 = null;
                    processingEnv.popVariables();
                    processingEnv.popParameters();
                }
                Object var7_8 = null;
                processingEnv.popVariables();
                processingEnv.popParameters();
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                processingEnv.popVariables();
                processingEnv.popParameters();
                throw throwable;
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            processingEnv.getContext().popState();
            throw throwable;
        }
        processingEnv.getContext().popState();
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.print("apply-templates");
        if (this.mode != Mode.DEFAULT_MODE) {
            printWriter.print(" mode=" + this.mode.getName());
        }
        printWriter.println();
        if (this.select != null) {
            Util.indent(printWriter, n + 1);
            printWriter.println("select");
            this.select.dump(printWriter, n + 2);
        }
        if (this.sortCriteria != null) {
            this.sortCriteria.dump(printWriter, n + 1);
        }
    }
}

