/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.Namespace;
import com.novell.xml.xpath.AxisAttribute;
import com.novell.xml.xpath.AxisNamespace;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.ResultTreeFragment;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class CopyOfTemplate
implements Template {
    private final Expression select;
    private final Node nsContext;

    public CopyOfTemplate(Expression expression, Node node) {
        this.select = expression;
        this.nsContext = node;
    }

    public Expression getSelect() {
        return this.select;
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("copy-of");
        try {
            ExpressionValue expressionValue = processingEnv.getContext().evaluate(node, this.select);
            Trace.traceSelect(this.select, expressionValue);
            if (expressionValue.getValueType() == 3) {
                this.copyNodeSet(expressionValue.getNodeSetValue(), resultHandler, processingEnv);
            } else if (expressionValue.getValueType() == 4 && expressionValue instanceof ResultTreeFragment) {
                this.copyResultFragment((ResultTreeFragment)expressionValue, resultHandler, processingEnv);
            } else {
                resultHandler.characters(expressionValue.getStringValue());
            }
        }
        catch (IllegalNodeException illegalNodeException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException resultException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe8", resultException.getMessage());
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("copy-of");
        Util.indent(printWriter, n + 1);
        printWriter.println("select:");
        this.select.dump(printWriter, n + 2);
    }

    private void copyNode(Node node, ResultHandler resultHandler, ProcessingEnv processingEnv, boolean bl) throws IllegalNodeException, ResultException, XSLException {
        switch (XPathUtil.getNodeType(node)) {
            case 2: {
                resultHandler.attribute(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 1: {
                resultHandler.startElement(node.getNodeName(), DOMUtil.getNamespaceName(node).getString());
                AxisAttribute axisAttribute = new AxisAttribute();
                axisAttribute.setup(node, processingEnv.getContext());
                Node node2 = axisAttribute.first();
                while (node2 != null) {
                    this.copyNode(node2, resultHandler, processingEnv, bl);
                    node2 = axisAttribute.next();
                }
                AxisNamespace axisNamespace = new AxisNamespace();
                axisNamespace.setup(node, processingEnv.getContext());
                Node node3 = axisNamespace.first();
                while (node3 != null) {
                    ProcessingEnv.resultNamespace(resultHandler, node3.getNodeName(), ((Namespace)node3).getNamespaceName());
                    node3 = axisNamespace.next();
                }
                Node node4 = node.getFirstChild();
                while (node4 != null) {
                    this.copyNode(node4, resultHandler, processingEnv, bl);
                    node4 = XPathUtil.getNextSibling(node4);
                }
                resultHandler.endElement(node.getNodeName());
                break;
            }
            case 7: {
                resultHandler.processingInstruction(((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            case 8: {
                resultHandler.comment(((Comment)node).getNodeValue());
                break;
            }
            case 3: {
                if (bl && processingEnv.getContext().stripNode(node)) break;
                resultHandler.characters(XPathUtil.getNodeValue(node));
                break;
            }
            case 9: 
            case 11: {
                Node node5 = node.getFirstChild();
                while (node5 != null) {
                    this.copyNode(node5, resultHandler, processingEnv, bl);
                    node5 = XPathUtil.getNextSibling(node5);
                }
                break;
            }
            case -1: {
                ProcessingEnv.resultNamespace(resultHandler, node.getNodeName(), ((Namespace)node).getNamespaceName());
                break;
            }
        }
    }

    private void copyNodeSet(NodeSet nodeSet, ResultHandler resultHandler, ProcessingEnv processingEnv) throws IllegalNodeException, ResultException, XSLException {
        Node node = nodeSet.first();
        while (node != null) {
            this.copyNode(node, resultHandler, processingEnv, true);
            node = nodeSet.next();
        }
    }

    private void copyResultFragment(ResultTreeFragment resultTreeFragment, ResultHandler resultHandler, ProcessingEnv processingEnv) throws IllegalNodeException, ResultException, XSLException {
        Node node = resultTreeFragment.getRoot();
        if (node != null) {
            this.copyNode(node, resultHandler, processingEnv, false);
        }
    }
}

