/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.Namespace;
import com.novell.xml.xpath.AxisNamespace;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.AttributeSetCollection;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.Collection;
import org.w3c.dom.Node;

public class CopyTemplate
extends TemplateCollection {
    private final AttributeSetCollection attributeSets;

    public CopyTemplate(Collection collection, Template[] templateArray, Node node) {
        super(templateArray, node);
        this.attributeSets = collection != null && collection.size() != 0 ? new AttributeSetCollection(collection) : null;
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("copy");
        try {
            switch (XPathUtil.getNodeType(node)) {
                case 9: 
                case 11: {
                    this.instantiateTemplates(processingEnv, node, resultHandler);
                    break;
                }
                case 1: {
                    String string = node.getNodeName();
                    String string2 = DOMUtil.getNamespaceName(node).getString();
                    resultHandler.startElement(string, string2);
                    AxisNamespace axisNamespace = new AxisNamespace();
                    axisNamespace.setup(node, processingEnv.getContext());
                    Node node2 = axisNamespace.first();
                    while (node2 != null) {
                        ProcessingEnv.resultNamespace(resultHandler, node2.getNodeName(), ((Namespace)node2).getNamespaceName());
                        node2 = axisNamespace.next();
                    }
                    if (this.attributeSets != null) {
                        this.attributeSets.instantiate(processingEnv, node, resultHandler);
                    }
                    this.instantiateTemplates(processingEnv, node, resultHandler);
                    resultHandler.endElement(string);
                    break;
                }
                case 2: {
                    resultHandler.attribute(node.getNodeName(), node.getNodeValue());
                    break;
                }
                case 8: {
                    resultHandler.comment(node.getNodeValue());
                    break;
                }
                case 7: {
                    resultHandler.processingInstruction(node.getNodeName(), node.getNodeValue());
                    break;
                }
                case 3: {
                    resultHandler.characters(XPathUtil.getNodeValue(node));
                    break;
                }
                case -1: {
                    ProcessingEnv.resultNamespace(resultHandler, node.getNodeName(), ((Namespace)node).getNamespaceName());
                    break;
                }
            }
        }
        catch (AttributeAfterChildException attributeAfterChildException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe6", node.getNodeName());
        }
        catch (IllegalNameException illegalNameException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe5", node.getNodeName());
        }
        catch (IllegalNodeException illegalNodeException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException resultException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe8", resultException.getMessage());
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("copy");
        super.dump(printWriter, n);
    }
}

