/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.util.NamespaceName;
import com.novell.xml.util.XMLUtil;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.AttributeSetCollection;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.Collection;
import org.w3c.dom.Node;

public class ElementTemplate
extends TemplateCollection {
    private final Expression name;
    private final Expression namespace;
    private final AttributeSetCollection attributeSets;

    public ElementTemplate(Expression expression, Expression expression2, Collection collection, Template[] templateArray, Node node) {
        super(templateArray, node);
        this.name = expression;
        this.namespace = expression2;
        this.attributeSets = collection != null && collection.size() != 0 ? new AttributeSetCollection(collection) : null;
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("element");
        String string = "";
        try {
            int n;
            string = processingEnv.getContext().evaluate(node, this.name).getStringValue();
            if (!XMLUtil.isQName(string)) {
                processingEnv.reportError(this.getNamespaceContext(), "pe5", string);
            }
            String string2 = (n = string.indexOf(58)) != -1 ? string.substring(0, n) : "";
            NamespaceName namespaceName = this.namespace == null ? processingEnv.getContext().getNamespaceName(string2) : new NamespaceName(processingEnv.getContext().evaluate(node, this.namespace).getStringValue());
            resultHandler.startElement(string, namespaceName.getString());
            if (namespaceName != null && !namespaceName.isEmpty()) {
                ProcessingEnv.resultNamespace(resultHandler, string2, namespaceName);
            }
            if (this.attributeSets != null) {
                this.attributeSets.instantiate(processingEnv, node, resultHandler);
            }
            this.instantiateTemplates(processingEnv, node, resultHandler);
            resultHandler.endElement(string);
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
        }
        catch (IllegalNameException illegalNameException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe5", string);
        }
        catch (IllegalNodeException illegalNodeException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException resultException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe8", resultException.getMessage());
        }
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("element");
        Util.indent(printWriter, n + 1);
        printWriter.println("name");
        this.name.dump(printWriter, n + 2);
        super.dump(printWriter, n);
    }
}

