/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.dom.Namespace;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import com.novell.xml.xpath.Axis;
import com.novell.xml.xpath.AxisNamespace;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.Stylesheet;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.AttributeSetCollection;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.process.TemplateCollection;
import com.novell.xsl.result.AttributeAfterChildException;
import com.novell.xsl.result.IllegalNameException;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class LiteralElementTemplate
extends TemplateCollection {
    private String elementName;
    private String[] attributeNames;
    private Expression[] attributeValues;
    private Set extNamespaces;
    private Set excludedNamespaces;
    private AttributeSetCollection attributeSets;

    public LiteralElementTemplate(String string, String[] stringArray, Expression[] expressionArray, Set set, Set set2, Collection collection, Template[] templateArray, Node node) {
        super(templateArray, node);
        this.elementName = string;
        if (stringArray.length != expressionArray.length) {
            throw new IllegalArgumentException("mismatched number of attribute names and values");
        }
        if (stringArray.length > 0) {
            this.attributeNames = stringArray;
            this.attributeValues = expressionArray;
        } else {
            this.attributeNames = null;
            this.attributeValues = null;
        }
        this.extNamespaces = set;
        this.excludedNamespaces = set2;
        this.attributeSets = collection != null && collection.size() != 0 ? new AttributeSetCollection(collection) : null;
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("<" + this.elementName + ">");
        int n = 0;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            Stylesheet stylesheet = processingEnv.getStylesheet();
            if (this.attributeNames != null) {
                while (n < this.attributeNames.length) {
                    if (this.attributeValues[n] != null) {
                        object4 = processingEnv.getContext().evaluate(node, this.attributeValues[n]).getStringValue();
                        if (this.attributeNames[n].startsWith("xmlns")) {
                            object3 = new NamespaceName((String)object4);
                            if (!(((NamespaceName)object3).equals(Stylesheet.NAMESPACE) || this.extNamespaces.contains(object3) || this.excludedNamespaces.contains(object3))) {
                                object2 = stylesheet.getAliasedNamespace((NamespaceName)object3);
                                if (object2 != null) {
                                    object = stylesheet.getAliasedPrefix((NamespaceName)object3);
                                    object3 = object2;
                                } else {
                                    int n2 = this.attributeNames[n].indexOf(58);
                                    object = n2 != -1 ? this.attributeNames[n].substring(n2 + 1, this.attributeNames[n].length()) : "";
                                }
                                hashMap.put(object3, object);
                            }
                        } else {
                            object3 = new ExpandedQName(this.attributeNames[n], this.getNamespaceContext());
                            object = ((ExpandedQName)object3).getNamespaceName();
                            if (!((NamespaceName)object).equals(Stylesheet.NAMESPACE) && !this.extNamespaces.contains(object)) {
                                arrayList.add(new Attribute(this.attributeNames[n], (String)object4));
                            }
                        }
                    }
                    ++n;
                }
            }
            object4 = new AxisNamespace();
            ((Axis)object4).setup(this.getNamespaceContext(), processingEnv.getContext());
            object3 = ((AxisNamespace)object4).first();
            while (object3 != null) {
                object = ((Namespace)object3).getNamespaceName();
                if (((NamespaceName)object).equals(Stylesheet.NAMESPACE) || this.extNamespaces.contains(object) || this.excludedNamespaces.contains(object)) {
                    object3 = ((AxisNamespace)object4).next();
                    continue;
                }
                NamespaceName namespaceName = stylesheet.getAliasedNamespace((NamespaceName)object);
                if (namespaceName != null) {
                    object2 = stylesheet.getAliasedPrefix((NamespaceName)object);
                    object = namespaceName;
                } else {
                    object2 = object3.getNodeName();
                }
                hashMap.put(object, object2);
                object3 = ((AxisNamespace)object4).next();
            }
            object = this.adjustPrefix(this.elementName, processingEnv, hashMap);
            object2 = this.getNamespaceURI((String)object, processingEnv);
            try {
                Object object5;
                try {
                    resultHandler.startElement((String)object, (String)object2);
                }
                catch (IllegalNameException illegalNameException) {
                    processingEnv.reportError(this.getNamespaceContext(), "pe5", (String)object);
                }
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    object5 = (NamespaceName)iterator.next();
                    ProcessingEnv.resultNamespace(resultHandler, (String)hashMap.get(object5), (NamespaceName)object5);
                }
                if (this.attributeSets != null) {
                    this.attributeSets.instantiate(processingEnv, node, resultHandler);
                }
                object5 = arrayList.iterator();
                Attribute attribute = null;
                try {
                    while (object5.hasNext()) {
                        attribute = (Attribute)object5.next();
                        resultHandler.attribute(this.adjustPrefix(attribute.getName(), processingEnv, hashMap), attribute.getValue());
                    }
                }
                catch (IllegalNameException illegalNameException) {
                    processingEnv.reportError(this.getNamespaceContext(), "pe5", attribute.getName());
                }
                this.instantiateTemplates(processingEnv, node, resultHandler);
                resultHandler.endElement((String)object);
            }
            catch (AttributeAfterChildException attributeAfterChildException) {
                processingEnv.reportError(this.getNamespaceContext(), "pe6", "");
            }
            catch (IllegalNodeException illegalNodeException) {
                processingEnv.reportError(this.getNamespaceContext(), "pe7");
            }
            catch (ResultException resultException) {
                processingEnv.reportError(this.getNamespaceContext(), "pe8", resultException.getMessage());
            }
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
        }
    }

    protected String adjustPrefix(String string, ProcessingEnv processingEnv, Map map) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        NamespaceName namespaceName = processingEnv.getContext().getNamespaceName(string2);
        String string3 = (String)map.get(namespaceName);
        if (string3 == null) {
            string3 = processingEnv.getStylesheet().getAliasedPrefix(namespaceName);
        }
        if (string3 == null || string3.equals(string2)) {
            return string;
        }
        return string3 + ":" + string.substring(n + 1, string.length());
    }

    protected String getNamespaceURI(String string, ProcessingEnv processingEnv) {
        String string2 = null;
        int n = string.indexOf(58);
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        NamespaceName namespaceName = processingEnv.getContext().getNamespaceName(string2);
        return namespaceName.getString();
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("literal element " + this.elementName);
        if (this.attributeNames != null) {
            int n2 = 0;
            while (n2 < this.attributeNames.length) {
                Util.indent(printWriter, n + 1);
                printWriter.println("literal attribute " + this.attributeNames[n2]);
                this.attributeValues[n2].dump(printWriter, n + 2);
                ++n2;
            }
        }
        super.dump(printWriter, n);
    }

    static class Attribute {
        private String name;
        private String value;

        public Attribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

