/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xsl.process;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xsl.XSLException;
import com.novell.xsl.debug.Trace;
import com.novell.xsl.process.ProcessingEnv;
import com.novell.xsl.process.Template;
import com.novell.xsl.result.IllegalNodeException;
import com.novell.xsl.result.ResultException;
import com.novell.xsl.result.ResultHandler;
import com.novell.xsl.result.Serializer;
import com.novell.xsl.util.Util;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class ValueOfTemplate
implements Template {
    private final Expression stringExpr;
    private final boolean noEscaping;
    private final Node nsContext;

    public ValueOfTemplate(Expression expression, boolean bl, Node node) {
        this.stringExpr = expression;
        this.noEscaping = bl;
        this.nsContext = node;
    }

    public Expression getExpr() {
        return this.stringExpr;
    }

    public void instantiate(ProcessingEnv processingEnv, Node node, ResultHandler resultHandler) throws XSLException {
        Trace.traceTemplate("value-of");
        try {
            ExpressionValue expressionValue = processingEnv.getContext().evaluate(node, this.stringExpr);
            Trace.traceSelect(this.stringExpr, expressionValue);
            String string = expressionValue.getStringValue();
            if (string.length() > 0) {
                if (resultHandler instanceof Serializer) {
                    ((Serializer)((Object)resultHandler)).noTextEscaping(this.noEscaping);
                    resultHandler.characters(expressionValue.getStringValue());
                    ((Serializer)((Object)resultHandler)).noTextEscaping(false);
                } else {
                    resultHandler.characters(expressionValue.getStringValue());
                }
            }
        }
        catch (IllegalNodeException illegalNodeException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe7");
        }
        catch (ResultException resultException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe8", resultException.getMessage());
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            processingEnv.reportError(this.getNamespaceContext(), "pe2", xPathEvaluationException.getMessage());
        }
    }

    public Node getNamespaceContext() {
        return this.nsContext;
    }

    public void dump(PrintWriter printWriter, int n) {
        Util.indent(printWriter, n);
        printWriter.println("value-of");
        Util.indent(printWriter, n);
        printWriter.println("    expression");
        this.stringExpr.dump(printWriter, n + 1);
    }
}

