/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.skeleton;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSProductElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSReadAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSSearchAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSSearchClassElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class CommonImpl {
    private static final String PRODUCT_NAME = "DirXML Skeleton Driver (Java, XDS)";
    private static final String COMPANY_NAME = "My Company Name";
    private static final String VERSION = "3.5.2";
    protected static final String TRACE_ID = "Skeleton Driver";
    protected Map driverParams = null;
    protected String driverRDN = null;
    protected Trace trace = null;
    protected boolean connected = false;

    protected CommonImpl() {
    }

    protected void setDriverParams(Map map) {
        this.driverParams = map;
    }

    Map getDriverParams() {
        return this.driverParams;
    }

    protected void setDriverRDN(String string) {
        this.driverRDN = string;
    }

    protected String getDriverRDN() {
        return this.driverRDN == null ? TRACE_ID : this.driverRDN;
    }

    protected void setTrace() {
        this.trace = new Trace(null);
    }

    protected void appendSourceInfo(WriteableDocument writeableDocument) {
        if (writeableDocument != null) {
            XDSSourceElement xDSSourceElement = writeableDocument.appendSourceElement();
            XDSProductElement xDSProductElement = xDSSourceElement.appendProductElement();
            xDSProductElement.setBuild("20070620_0505");
            xDSProductElement.setInstance(this.driverRDN);
            xDSProductElement.setVersion(VERSION);
            xDSProductElement.appendText(PRODUCT_NAME);
            xDSSourceElement.appendContactElement(COMPANY_NAME);
        }
    }

    protected XDSResultDocument newResultDoc() {
        XDSResultDocument xDSResultDocument = new XDSResultDocument();
        this.appendSourceInfo((WriteableDocument)xDSResultDocument);
        return xDSResultDocument;
    }

    protected XDSCommandDocument newCommandDoc() {
        XDSCommandDocument xDSCommandDocument = new XDSCommandDocument();
        this.appendSourceInfo((WriteableDocument)xDSCommandDocument);
        return xDSCommandDocument;
    }

    protected static String toLiteral(String string) {
        return string == null ? null : "'" + string + "'";
    }

    protected void connect() throws IOException {
        this.trace.trace("connect", 1);
        if (!this.connected) {
            this.connected = true;
        }
    }

    protected void disconnect() {
        this.trace.trace("disconnect", 1);
        this.connected = false;
    }

    protected void queryHandler(XDSQueryElement xDSQueryElement, QueryResultDocument queryResultDocument) {
        this.trace.trace("queryHandler", 1);
        if (xDSQueryElement == null) {
            return;
        }
        this.trace.trace("queryHandler: association      == " + CommonImpl.toLiteral(xDSQueryElement.extractAssociationText()));
        this.trace.trace("queryHandler: class-name       == " + CommonImpl.toLiteral(xDSQueryElement.getClassName()));
        this.trace.trace("queryHandler: dest-dn          == " + CommonImpl.toLiteral(xDSQueryElement.getDestDN()));
        this.trace.trace("queryHandler: event-id         == " + CommonImpl.toLiteral(xDSQueryElement.getEventID()));
        this.trace.trace("queryHandler: max-result-count == " + xDSQueryElement.getMaxResultCount());
        this.trace.trace("queryHandler: qualified-src-dn == " + CommonImpl.toLiteral(xDSQueryElement.getQualifiedSrcDN()));
        this.trace.trace("queryHandler: scope            == " + CommonImpl.toLiteral(xDSQueryElement.getScope().toString()));
        this.trace.trace("queryHandler: src-dn           == " + CommonImpl.toLiteral(xDSQueryElement.getSrcDN()));
        this.trace.trace("queryHandler: src-entry-id     == " + CommonImpl.toLiteral(xDSQueryElement.getSrcEntryID()));
        List list = xDSQueryElement.extractSearchClassElements();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            XDSSearchClassElement xDSSearchClassElement = (XDSSearchClassElement)listIterator.next();
            this.trace.trace("queryHandler: search-class     == " + CommonImpl.toLiteral(xDSSearchClassElement.getClassName()));
        }
        List list2 = xDSQueryElement.extractSearchAttrElements();
        listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            XDSSearchAttrElement xDSSearchAttrElement = (XDSSearchAttrElement)listIterator.next();
            this.trace.trace("queryHandler: search-attr      == " + CommonImpl.toLiteral(xDSSearchAttrElement.getAttrName()));
        }
        List list3 = xDSQueryElement.extractReadAttrElements();
        listIterator = list3.listIterator();
        while (listIterator.hasNext()) {
            XDSReadAttrElement xDSReadAttrElement = (XDSReadAttrElement)listIterator.next();
            this.trace.trace("queryHandler: read-attr        == " + CommonImpl.toLiteral(xDSReadAttrElement.getAttrName()));
        }
        this.trace.trace("queryHandler: contains query token?       " + xDSQueryElement.containsQueryToken());
        this.trace.trace("queryHandler: contains read attrs?        " + xDSQueryElement.containsReadAttrElements());
        this.trace.trace("queryHandler: contains search attrs?      " + xDSQueryElement.containsSearchAttrElements());
        this.trace.trace("queryHandler: contains search classes?    " + xDSQueryElement.containsSearchClassElements());
        this.trace.trace("queryHandler: has entry scope?            " + xDSQueryElement.hasEntryScope());
        this.trace.trace("queryHandler: has subordinates scope?     " + xDSQueryElement.hasSubordinatesScope());
        this.trace.trace("queryHandler: has subtree scope?          " + xDSQueryElement.hasSubtreeScope());
        this.trace.trace("queryHandler: has limited results?        " + xDSQueryElement.hasLimitedResults());
        this.trace.trace("queryHandler: has unlimited results?      " + xDSQueryElement.hasUnlimitedResults());
        this.trace.trace("queryHandler: has root base object?       " + xDSQueryElement.hasRootBaseObject());
        this.trace.trace("queryHandler: is cancelled query?         " + xDSQueryElement.isCancelled());
        this.trace.trace("queryHandler: is extended query?          " + xDSQueryElement.isExtended());
        this.trace.trace("queryHandler: is identity query?          " + xDSQueryElement.isIdentity());
        this.trace.trace("queryHandler: is initial query?           " + xDSQueryElement.isInitialQuery());
        this.trace.trace("queryHandler: is subsequent query?        " + xDSQueryElement.isSubsequentQuery());
        this.trace.trace("queryHandler: should read attrs?          " + xDSQueryElement.shouldReadAttributes());
        this.trace.trace("queryHandler: should read parent?         " + xDSQueryElement.shouldReadParent());
        this.trace.trace("queryHandler: should search all classes?  " + xDSQueryElement.shouldSearchAllClasses());
    }
}

