/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.skeleton;

import com.novell.nds.dirxml.driver.DriverShim;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.EnumConstraint;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RegExConstraint;
import com.novell.nds.dirxml.driver.xds.RequiredConstraint;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAttrDefElement;
import com.novell.nds.dirxml.driver.xds.XDSClassDefElement;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSSchemaDefElement;
import com.novell.nds.dirxml.driver.xds.XDSSchemaResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.skeleton.CommonImpl;
import com.novell.nds.dirxml.driver.xds.skeleton.SkeletonPublicationShim;
import com.novell.nds.dirxml.driver.xds.skeleton.SkeletonSubscriptionShim;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.util.HashMap;

public class SkeletonDriverShim
extends CommonImpl
implements DriverShim {
    private static final int NO_OF_PARAMS = 9;
    private static final String TAG_OPTION_1 = "option-1";
    private static final String TAG_OPTION_2 = "option-2";
    private static final String TAG_OPTION_3 = "option-3";
    private static final String TAG_OPTION_4 = "option-4";
    private static final String TAG_OPTION_5 = "option-5";
    private static final String TAG_OPTION_6 = "option-6";
    private static final String DEFAULT_OPTION_1 = "any string will do";
    private static final String DEFAULT_OPTION_2 = "10";
    private static final String DEFAULT_OPTION_3 = "true";
    private static final String DEFAULT_OPTION_4 = "1";
    private static final String DEFAULT_OPTION_5 = null;
    private static final String DEFAULT_OPTION_6 = null;
    private static final String DEFAULT_SERVER = null;
    private static final String DEFAULT_USER = null;
    private static final String DEFAULT_PASSWORD = null;
    private static final String APPLICATION_NAME = "Skeleton Application";
    private SkeletonSubscriptionShim subscriptionShim;
    private SkeletonPublicationShim publicationShim;

    public SkeletonDriverShim() {
        this.setDriverRDN("Skeleton Driver");
        this.setTrace();
        this.setDriverParams();
        this.subscriptionShim = null;
        this.publicationShim = null;
    }

    private void setDriverParams() {
        this.driverParams = new HashMap(9);
        Parameter parameter = new Parameter(TAG_OPTION_1, DEFAULT_OPTION_1, DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_OPTION_2, DEFAULT_OPTION_2, DataType.INT);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_OPTION_3, DEFAULT_OPTION_3, DataType.BOOLEAN);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_OPTION_4, DEFAULT_OPTION_4, DataType.INT);
        EnumConstraint enumConstraint = new EnumConstraint();
        enumConstraint.addLiterals(new String[]{DEFAULT_OPTION_4, "2", "3"});
        parameter.add((Constraint)enumConstraint);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_OPTION_5, DEFAULT_OPTION_5, DataType.STRING);
        RegExConstraint regExConstraint = new RegExConstraint("a*b");
        parameter.add((Constraint)regExConstraint);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_OPTION_6, DEFAULT_OPTION_6, DataType.STRING);
        parameter.add((Constraint)RequiredConstraint.REQUIRED);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("server", DEFAULT_SERVER, DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("user", DEFAULT_USER, DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("password", DEFAULT_PASSWORD, DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        this.trace.trace("init", 1);
        XDSResultDocument xDSResultDocument = new XDSResultDocument();
        try {
            XDSInitDocument xDSInitDocument = new XDSInitDocument(xmlDocument);
            this.setDriverRDN(xDSInitDocument.rdn());
            this.setTrace();
            this.appendSourceInfo((WriteableDocument)xDSResultDocument);
            xDSInitDocument.parameters(this.driverParams);
            if (this.driverParams.get("server").toString() == null && this.driverParams.get("user").toString() == null && this.driverParams.get("password").toString() == null) {
                StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_GENERAL, null);
                XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, (String)"Missing authentication information.");
            } else {
                this.subscriptionShim = new SkeletonSubscriptionShim(this);
                this.publicationShim = new SkeletonPublicationShim(this);
                StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
                XDSStatusElement xDSStatusElement = XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null);
                xDSStatusElement.parametersAppend(this.driverParams);
            }
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
        }
        return xDSResultDocument.toXML();
    }

    public XmlDocument shutdown(XmlDocument xmlDocument) {
        this.trace.trace("shutdown", 1);
        XDSResultDocument xDSResultDocument = this.newResultDoc();
        try {
            if (this.publicationShim != null) {
                this.publicationShim.shutdown();
            }
            if (this.subscriptionShim != null) {
                this.subscriptionShim.shutdown();
            }
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)true, null);
        }
        return xDSResultDocument.toXML();
    }

    public SubscriptionShim getSubscriptionShim() {
        this.trace.trace("getSubscriptionShim", 1);
        return this.subscriptionShim;
    }

    public PublicationShim getPublicationShim() {
        this.trace.trace("getPublicationShim", 1);
        return this.publicationShim;
    }

    public XmlDocument getSchema(XmlDocument xmlDocument) {
        this.trace.trace("getSchema", 1);
        XDSSchemaResultDocument xDSSchemaResultDocument = new XDSSchemaResultDocument();
        try {
            XDSInitDocument xDSInitDocument = new XDSInitDocument(xmlDocument);
            this.setDriverRDN(xDSInitDocument.rdn());
            this.setTrace();
            this.appendSourceInfo((WriteableDocument)xDSSchemaResultDocument);
            xDSInitDocument.parameters(this.driverParams);
            XDSSchemaDefElement xDSSchemaDefElement = xDSSchemaResultDocument.appendSchemaDefElement();
            xDSSchemaDefElement.setApplicationName(APPLICATION_NAME);
            xDSSchemaDefElement.setHierarchical(true);
            XDSClassDefElement xDSClassDefElement = xDSSchemaDefElement.appendClassDefElement();
            xDSClassDefElement.setClassName("fake-class-1");
            xDSClassDefElement.setContainer(true);
            XDSAttrDefElement xDSAttrDefElement = xDSClassDefElement.appendAttrDefElement();
            xDSAttrDefElement.setAttrName("fake-attr-1");
            xDSAttrDefElement.setCaseSensitive(true);
            xDSAttrDefElement.setMultiValued(true);
            xDSAttrDefElement.setNaming(true);
            xDSAttrDefElement.setReadOnly(true);
            xDSAttrDefElement.setRequired(true);
            xDSAttrDefElement.setType(ValueType.STRING);
            xDSClassDefElement = xDSSchemaDefElement.appendClassDefElement();
            xDSClassDefElement.setClassName("fake-class-2");
            xDSClassDefElement.setContainer(false);
            xDSAttrDefElement = xDSClassDefElement.appendAttrDefElement();
            xDSAttrDefElement.setAttrName("fake-attr-2");
            xDSAttrDefElement.setCaseSensitive(false);
            xDSAttrDefElement.setMultiValued(false);
            xDSAttrDefElement.setNaming(false);
            xDSAttrDefElement.setReadOnly(false);
            xDSAttrDefElement.setRequired(false);
            xDSAttrDefElement.setType(ValueType.INT);
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.WARNING, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)xDSSchemaResultDocument, (StatusAttributes)statusAttributes, (String)"Get schema not implemented.");
        }
        catch (Exception exception) {
            xDSSchemaResultDocument.empty();
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSSchemaResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
        }
        return xDSSchemaResultDocument.toXML();
    }
}

