/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.skeleton;

import com.novell.nds.dirxml.driver.DriverFilter;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSCommandResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSHeartbeatDocument;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryDocument;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.skeleton.CommonImpl;
import com.novell.nds.dirxml.driver.xds.skeleton.SkeletonDriverShim;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

public class SkeletonPublicationShim
extends CommonImpl
implements PublicationShim,
XmlQueryProcessor {
    private static final int NO_OF_PARAMS = 3;
    private static final String TAG_PUB_1 = "pub-1";
    private static final String TAG_POLLING_INTERVAL = "polling-interval";
    private static final String TAG_HEARTBEAT_INTERVAL = "pub-heartbeat-interval";
    private static final String DEFAULT_PUB_1 = "String for Publisher";
    private static final String DEFAULT_POLLING_INTERVAL = "10";
    private static final String DEFAULT_HEARTBEAT_INTERVAL = "0";
    private boolean shutdown;
    private long pollingInterval;
    private long heartbeatInterval;
    private boolean doHeartbeat;
    private long interval;
    private Object semaphore;
    private DriverFilter filter;
    private Map pubParams;
    private SkeletonDriverShim driver;

    SkeletonPublicationShim(SkeletonDriverShim skeletonDriverShim) {
        this.driver = skeletonDriverShim;
        this.setDriverRDN(this.driver.getDriverRDN());
        this.setTrace();
        this.setDriverParams(this.driver.getDriverParams());
        this.setPubParams();
        this.shutdown = false;
        this.pollingInterval = -1L;
        this.semaphore = new short[0];
        this.filter = null;
        this.doHeartbeat = false;
    }

    private void setPubParams() {
        this.pubParams = new HashMap(3);
        Parameter parameter = new Parameter(TAG_PUB_1, DEFAULT_PUB_1, DataType.STRING);
        this.pubParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_POLLING_INTERVAL, DEFAULT_POLLING_INTERVAL, DataType.INT);
        parameter.add((Constraint)RangeConstraint.POSITIVE);
        this.pubParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_HEARTBEAT_INTERVAL, DEFAULT_HEARTBEAT_INTERVAL, DataType.INT);
        parameter.add((Constraint)RangeConstraint.NON_NEGATIVE);
        this.pubParams.put(parameter.tagName(), parameter);
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        this.trace.trace("init", 1);
        XDSResultDocument xDSResultDocument = this.newResultDoc();
        try {
            XDSInitDocument xDSInitDocument = new XDSInitDocument(xmlDocument);
            xDSInitDocument.parameters(this.pubParams);
            Parameter parameter = (Parameter)this.pubParams.get(TAG_POLLING_INTERVAL);
            this.pollingInterval = XDSUtil.toMillis((int)parameter.toInteger());
            parameter = (Parameter)this.pubParams.get(TAG_HEARTBEAT_INTERVAL);
            this.heartbeatInterval = XDSUtil.toMillis((int)(parameter.toInteger() * 60));
            this.doHeartbeat = this.heartbeatInterval > 0L;
            this.interval = this.doHeartbeat ? Math.min(this.pollingInterval, this.heartbeatInterval) : this.pollingInterval;
            this.filter = xDSInitDocument.driverFilter();
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSStatusElement xDSStatusElement = XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null);
            xDSStatusElement.parametersAppend(this.pubParams);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
        }
        return xDSResultDocument.toXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument start(XmlCommandProcessor xmlCommandProcessor) {
        this.trace.trace("start", 1);
        XDSResultDocument xDSResultDocument = this.newResultDoc();
        XmlDocument xmlDocument = new XDSHeartbeatDocument().toXML();
        StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
        long l = this.pollingInterval;
        long l2 = this.heartbeatInterval;
        try {
            while (!this.shutdown) {
                try {
                    boolean bl = false;
                    if (l >= this.pollingInterval) {
                        this.connect();
                        bl = this.poll(xmlCommandProcessor);
                        l = 0L;
                    }
                    if (bl) {
                        l2 = 0L;
                    } else if (l2 >= this.heartbeatInterval) {
                        l2 = 0L;
                        if (this.doHeartbeat) {
                            this.trace.trace("sending heartbeat", 2);
                            xmlCommandProcessor.execute(xmlDocument, (XmlQueryProcessor)this);
                        }
                    }
                    long l3 = Math.min(this.pollingInterval - l, this.heartbeatInterval - l2);
                    if (l3 == 0L) {
                        l3 = this.interval;
                    }
                    Object object = this.semaphore;
                    synchronized (object) {
                        long l4 = System.currentTimeMillis();
                        this.trace.trace("sleeping for " + l3 / 1000L + " seconds", 2);
                        this.semaphore.wait(l3);
                        long l5 = System.currentTimeMillis() - l4;
                        l += l5;
                        l2 += l5;
                    }
                }
                catch (IOException iOException) {
                    this.disconnect();
                    this.connect();
                }
                catch (InterruptedException interruptedException) {
                }
            }
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null);
        }
        catch (Exception exception) {
            statusAttributes.setLevel(StatusLevel.FATAL);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)true, null);
        }
        finally {
            this.trace.trace("stopping...", 2);
            this.disconnect();
        }
        return xDSResultDocument.toXML();
    }

    private boolean poll(XmlCommandProcessor xmlCommandProcessor) {
        this.trace.trace("poll", 1);
        if (Math.random() > 0.35) {
            this.trace.trace("nothing to do", 2);
            return false;
        }
        String string = DEFAULT_HEARTBEAT_INTERVAL;
        XDSCommandResultDocument xDSCommandResultDocument = null;
        XDSCommandDocument xDSCommandDocument = this.newCommandDoc();
        StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.WARNING, (StatusType)StatusType.DRIVER_GENERAL, (String)string);
        XDSUtil.appendStatus((StatusDocument)xDSCommandDocument, (StatusAttributes)statusAttributes, (String)"Publisher not implemented.");
        xDSCommandResultDocument = null;
        try {
            xDSCommandResultDocument = new XDSCommandResultDocument(xmlCommandProcessor.execute(xDSCommandDocument.toXML(), (XmlQueryProcessor)this));
            StatusLevel statusLevel = xDSCommandResultDocument.mostSevereStatusLevel(string);
            this.trace.trace("start: status == " + SkeletonPublicationShim.toLiteral(statusLevel.toString()), 3);
        }
        catch (XDSParseException xDSParseException) {
            xDSCommandDocument = this.newCommandDoc();
            statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)xDSCommandDocument, (StatusAttributes)statusAttributes, (String)"Document is invalid.", (Exception)((Object)xDSParseException), (boolean)false, (XmlDocument)xDSCommandResultDocument.toXML());
            xmlCommandProcessor.execute(xDSCommandDocument.toXML(), (XmlQueryProcessor)this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.trace.trace("shutdown", 1);
        this.shutdown = true;
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
        }
    }

    public XmlDocument query(XmlDocument xmlDocument) {
        this.trace.trace("query", 1);
        XDSQueryResultDocument xDSQueryResultDocument = new XDSQueryResultDocument();
        this.appendSourceInfo((WriteableDocument)xDSQueryResultDocument);
        String string = null;
        try {
            XDSQueryDocument xDSQueryDocument = new XDSQueryDocument(xmlDocument);
            ListIterator listIterator = xDSQueryDocument.extractQueryElements().listIterator();
            while (listIterator.hasNext()) {
                XDSQueryElement xDSQueryElement = (XDSQueryElement)listIterator.next();
                string = xDSQueryElement.getEventID();
                this.queryHandler(xDSQueryElement, (QueryResultDocument)xDSQueryResultDocument);
                StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)string);
                XDSUtil.appendStatus((StatusDocument)xDSQueryResultDocument, (StatusAttributes)statusAttributes, null);
            }
        }
        catch (XDSException xDSException) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)xDSQueryResultDocument, (StatusAttributes)statusAttributes, null, (Exception)((Object)xDSException), (boolean)false, (XmlDocument)xmlDocument);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)xDSQueryResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)true, (XmlDocument)xmlDocument);
        }
        return xDSQueryResultDocument.toXML();
    }
}

