/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.skeleton;

import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.StateDocument;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAddAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSAddAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSAddElement;
import com.novell.nds.dirxml.driver.xds.XDSAddValueElement;
import com.novell.nds.dirxml.driver.xds.XDSCheckObjectPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSCommandResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSDeleteElement;
import com.novell.nds.dirxml.driver.xds.XDSElement;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSModifyAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSMoveElement;
import com.novell.nds.dirxml.driver.xds.XDSParentElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAllValuesElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveValueElement;
import com.novell.nds.dirxml.driver.xds.XDSRenameElement;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.XDSValueElement;
import com.novell.nds.dirxml.driver.xds.skeleton.CommonImpl;
import com.novell.nds.dirxml.driver.xds.skeleton.SkeletonDriverShim;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Element;

public class SkeletonSubscriptionShim
extends CommonImpl
implements SubscriptionShim {
    private static final int NO_OF_PARAMS = 2;
    private static final String TAG_CURRENT_ASSOCIATION = "current-association";
    private static final String TAG_SUB_1 = "sub-1";
    private static final String DEFAULT_SUB_1 = "String for Subscriber";
    private static final String DEFAULT_ASSOCIATION = "1";
    private static final String DRIVER_ID_VALUE = "JSKEL";
    private static final String DRIVER_MIN_ACTIVATION_VERSION = "0";
    private Map subParams;
    private int currentAssociation;
    private SkeletonDriverShim driver;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSAddElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSModifyElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSRenameElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSMoveElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSModifyPasswordElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSCheckObjectPasswordElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSAddValueElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSRemoveValueElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSRemoveAllValuesElement;

    SkeletonSubscriptionShim(SkeletonDriverShim skeletonDriverShim) {
        this.driver = skeletonDriverShim;
        this.setDriverRDN(this.driver.getDriverRDN());
        this.setTrace();
        this.setDriverParams(this.driver.getDriverParams());
        this.setSubParams();
        this.currentAssociation = -1;
    }

    private void setSubParams() {
        this.subParams = new HashMap(2);
        Parameter parameter = new Parameter(TAG_SUB_1, DEFAULT_SUB_1, DataType.STRING);
        this.subParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_CURRENT_ASSOCIATION, DEFAULT_ASSOCIATION, DataType.INT);
        parameter.add((Constraint)RangeConstraint.POSITIVE);
        this.subParams.put(parameter.tagName(), parameter);
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        this.trace.trace("init", 1);
        XDSResultDocument xDSResultDocument = this.newResultDoc();
        try {
            XDSInitDocument xDSInitDocument = new XDSInitDocument(xmlDocument);
            xDSInitDocument.parameters(this.subParams);
            this.currentAssociation = ((Parameter)this.subParams.get(TAG_CURRENT_ASSOCIATION)).toInteger();
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSStatusElement xDSStatusElement = XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null);
            xDSStatusElement.parametersAppend(this.subParams);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
        }
        return xDSResultDocument.toXML();
    }

    public XmlDocument execute(XmlDocument xmlDocument, XmlQueryProcessor xmlQueryProcessor) {
        this.trace.trace("execute", 1);
        XDSCommandResultDocument xDSCommandResultDocument = new XDSCommandResultDocument();
        this.appendSourceInfo((WriteableDocument)xDSCommandResultDocument);
        String string = null;
        try {
            XDSCommandDocument xDSCommandDocument = new XDSCommandDocument(xmlDocument);
            if (xDSCommandDocument.containsIdentityQuery()) {
                XDSQueryElement xDSQueryElement = xDSCommandDocument.identityQuery();
                string = xDSQueryElement.getEventID();
                this.appendDriverIdentityInfo(xDSCommandResultDocument);
                StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)string);
                XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, null);
            } else {
                this.connect();
                ListIterator listIterator = xDSCommandDocument.childElements().listIterator();
                while (listIterator.hasNext()) {
                    CommandElement commandElement = (CommandElement)listIterator.next();
                    string = commandElement.getEventID();
                    this.dispatch(commandElement, xDSCommandResultDocument);
                    StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)string);
                    XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, null);
                }
            }
        }
        catch (XDSException xDSException) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, null, (Exception)((Object)xDSException), (boolean)false, (XmlDocument)xmlDocument);
        }
        catch (IOException iOException) {
            this.connected = false;
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.RETRY, (StatusType)StatusType.APP_CONNECTION, string);
            XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, (String)"Communications error.", (Exception)iOException, (boolean)false, null);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, string);
            XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)true, (XmlDocument)xmlDocument);
        }
        return xDSCommandResultDocument.toXML();
    }

    private void dispatch(CommandElement commandElement, XDSCommandResultDocument xDSCommandResultDocument) throws XDSParseException {
        this.trace.trace("dispatch", 1);
        Class<?> clazz = commandElement.getClass();
        if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSAddElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSAddElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSAddElement")) : class$com$novell$nds$dirxml$driver$xds$XDSAddElement)) {
            this.addHandler((XDSAddElement)commandElement, xDSCommandResultDocument);
            this.appendStateInfo((StateDocument)xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSModifyElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSModifyElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSModifyElement")) : class$com$novell$nds$dirxml$driver$xds$XDSModifyElement)) {
            this.modifyHandler((XDSModifyElement)commandElement, xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSDeleteElement")) : class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement)) {
            this.deleteHandler((XDSDeleteElement)commandElement, xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSRenameElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSRenameElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSRenameElement")) : class$com$novell$nds$dirxml$driver$xds$XDSRenameElement)) {
            this.renameHandler((XDSRenameElement)commandElement, xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSMoveElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSMoveElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSMoveElement")) : class$com$novell$nds$dirxml$driver$xds$XDSMoveElement)) {
            this.moveHandler((XDSMoveElement)commandElement, xDSCommandResultDocument);
        } else if (commandElement instanceof XDSQueryElement) {
            this.queryHandler((XDSQueryElement)commandElement, (QueryResultDocument)xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSModifyPasswordElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSModifyPasswordElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSModifyPasswordElement")) : class$com$novell$nds$dirxml$driver$xds$XDSModifyPasswordElement)) {
            this.modifyPasswordHandler((XDSModifyPasswordElement)commandElement, xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSCheckObjectPasswordElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSCheckObjectPasswordElement = SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSCheckObjectPasswordElement")) : class$com$novell$nds$dirxml$driver$xds$XDSCheckObjectPasswordElement)) {
            this.checkObjectPasswordHandler((XDSCheckObjectPasswordElement)commandElement, xDSCommandResultDocument);
        } else {
            this.trace.trace("unhandled element:  " + commandElement.tagName(), 3);
        }
    }

    private void addHandler(XDSAddElement xDSAddElement, XDSCommandResultDocument xDSCommandResultDocument) {
        this.trace.trace("addHandler", 1);
        String string = xDSAddElement.getClassName();
        this.trace.trace("addHandler: class-name == " + SkeletonSubscriptionShim.toLiteral(string), 2);
        ListIterator listIterator = xDSAddElement.extractAddAttrElements().listIterator();
        while (listIterator.hasNext()) {
            XDSAddAttrElement xDSAddAttrElement = (XDSAddAttrElement)listIterator.next();
            this.trace.trace("addHandler: attr-name  == " + SkeletonSubscriptionShim.toLiteral(xDSAddAttrElement.getAttrName()), 2);
            ListIterator listIterator2 = xDSAddAttrElement.extractValueElements().listIterator();
            while (listIterator2.hasNext()) {
                XDSValueElement xDSValueElement = (XDSValueElement)listIterator2.next();
                this.trace.trace("addHandler:\tvalue == " + SkeletonSubscriptionShim.toLiteral(xDSValueElement.extractText()), 2);
            }
        }
        XDSAddAssociationElement xDSAddAssociationElement = xDSCommandResultDocument.appendAddAssociationElement();
        xDSAddAssociationElement.setDestDN(xDSAddElement.getSrcDN());
        xDSAddAssociationElement.setEventID(xDSAddElement.getEventID());
        xDSAddAssociationElement.appendText(String.valueOf(this.currentAssociation));
        ++this.currentAssociation;
    }

    private void modifyPasswordHandler(XDSModifyPasswordElement xDSModifyPasswordElement, XDSCommandResultDocument xDSCommandResultDocument) {
        this.trace.trace("modifyPasswordHandler", 1);
        String string = xDSModifyPasswordElement.getClassName();
        String string2 = xDSModifyPasswordElement.extractAssociationText();
        this.trace.trace("modifyPasswordHandler: class-name   == " + SkeletonSubscriptionShim.toLiteral(string), 2);
        this.trace.trace("modifyPasswordHandler: association  == " + SkeletonSubscriptionShim.toLiteral(string2), 2);
        String string3 = xDSModifyPasswordElement.extractOldPasswordText();
        this.trace.trace("modifyPasswordHandler: old-password == " + SkeletonSubscriptionShim.toLiteral(string3), 2);
        String string4 = xDSModifyPasswordElement.extractPasswordText();
        this.trace.trace("modifyPasswordHandler: new-password == " + SkeletonSubscriptionShim.toLiteral(string4), 2);
    }

    private void checkObjectPasswordHandler(XDSCheckObjectPasswordElement xDSCheckObjectPasswordElement, XDSCommandResultDocument xDSCommandResultDocument) {
        this.trace.trace("checkObjectPassword", 1);
        String string = xDSCheckObjectPasswordElement.extractAssociationText();
        String string2 = xDSCheckObjectPasswordElement.extractPasswordText();
        this.trace.trace("checkObjectPassword: association  == " + SkeletonSubscriptionShim.toLiteral(string), 2);
        this.trace.trace("checkObjectPassword: password     == " + SkeletonSubscriptionShim.toLiteral(string2), 2);
    }

    private void modifyHandler(XDSModifyElement xDSModifyElement, XDSCommandResultDocument xDSCommandResultDocument) {
        this.trace.trace("modifyHandler", 1);
        String string = xDSModifyElement.getClassName();
        String string2 = xDSModifyElement.extractAssociationText();
        this.trace.trace("modifyHandler: class-name  == " + SkeletonSubscriptionShim.toLiteral(string), 2);
        this.trace.trace("modifyHandler: association == " + SkeletonSubscriptionShim.toLiteral(string2), 2);
        ListIterator listIterator = xDSModifyElement.extractModifyAttrElements().listIterator();
        while (listIterator.hasNext()) {
            XDSModifyAttrElement xDSModifyAttrElement = (XDSModifyAttrElement)listIterator.next();
            String string3 = xDSModifyAttrElement.getAttrName();
            this.trace.trace("modifyHandler: attr-name   == " + SkeletonSubscriptionShim.toLiteral(string3), 2);
            ListIterator listIterator2 = xDSModifyAttrElement.childElements().listIterator();
            while (listIterator2.hasNext()) {
                XDSElement xDSElement = (XDSElement)listIterator2.next();
                if (xDSElement.getClass() == (class$com$novell$nds$dirxml$driver$xds$XDSAddValueElement == null ? SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSAddValueElement") : class$com$novell$nds$dirxml$driver$xds$XDSAddValueElement)) {
                    this.addValueHandler((XDSAddValueElement)xDSElement);
                    continue;
                }
                if (xDSElement.getClass() == (class$com$novell$nds$dirxml$driver$xds$XDSRemoveValueElement == null ? SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSRemoveValueElement") : class$com$novell$nds$dirxml$driver$xds$XDSRemoveValueElement)) {
                    this.removeValueHandler((XDSRemoveValueElement)xDSElement);
                    continue;
                }
                if (xDSElement.getClass() == (class$com$novell$nds$dirxml$driver$xds$XDSRemoveAllValuesElement == null ? SkeletonSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSRemoveAllValuesElement") : class$com$novell$nds$dirxml$driver$xds$XDSRemoveAllValuesElement)) {
                    this.removeAllValuesHandler((XDSRemoveAllValuesElement)xDSElement);
                    continue;
                }
                this.trace.trace("unhandled element:  " + xDSElement.tagName(), 3);
            }
        }
    }

    private void addValueHandler(XDSAddValueElement xDSAddValueElement) {
        ListIterator listIterator = xDSAddValueElement.extractValueElements().listIterator();
        while (listIterator.hasNext()) {
            XDSValueElement xDSValueElement = (XDSValueElement)listIterator.next();
            this.trace.trace("modifyHandler:\tadd-value    == " + SkeletonSubscriptionShim.toLiteral(xDSValueElement.extractText()), 2);
            ValueType valueType = xDSValueElement.getType();
        }
    }

    private void removeValueHandler(XDSRemoveValueElement xDSRemoveValueElement) {
        ListIterator listIterator = xDSRemoveValueElement.extractValueElements().listIterator();
        while (listIterator.hasNext()) {
            XDSValueElement xDSValueElement = (XDSValueElement)listIterator.next();
            this.trace.trace("modifyHandler:\tremove-value == " + SkeletonSubscriptionShim.toLiteral(xDSValueElement.extractText()), 2);
            ValueType valueType = xDSValueElement.getType();
        }
    }

    private void removeAllValuesHandler(XDSRemoveAllValuesElement xDSRemoveAllValuesElement) {
        this.trace.trace("modifyHandler:\tremove-all-values", 2);
    }

    private void deleteHandler(XDSDeleteElement xDSDeleteElement, XDSCommandResultDocument xDSCommandResultDocument) throws XDSParseException {
        this.trace.trace("deleteHandler", 1);
        String string = xDSDeleteElement.getClassName();
        String string2 = xDSDeleteElement.extractAssociationText();
        this.trace.trace("deleteHandler: class-name  == " + SkeletonSubscriptionShim.toLiteral(string), 2);
        this.trace.trace("deleteHandler: association == " + SkeletonSubscriptionShim.toLiteral(string2), 2);
        if (string2 == null) {
            throw new XDSParseException("Missing required association.");
        }
    }

    private void renameHandler(XDSRenameElement xDSRenameElement, XDSCommandResultDocument xDSCommandResultDocument) {
        this.trace.trace("renameHandler", 1);
        String string = xDSRenameElement.getClassName();
        String string2 = xDSRenameElement.extractAssociationText();
        this.trace.trace("renameHandler: class-name  == " + SkeletonSubscriptionShim.toLiteral(string), 2);
        this.trace.trace("renameHandler: association == " + SkeletonSubscriptionShim.toLiteral(string2), 2);
        String string3 = xDSRenameElement.extractNewNameText();
        this.trace.trace("renameHandler: new-name    == " + SkeletonSubscriptionShim.toLiteral(string3), 2);
    }

    private void moveHandler(XDSMoveElement xDSMoveElement, XDSCommandResultDocument xDSCommandResultDocument) {
        this.trace.trace("moveHandler", 1);
        String string = xDSMoveElement.getClassName();
        String string2 = xDSMoveElement.extractAssociationText();
        this.trace.trace("moveHandler: class       == " + SkeletonSubscriptionShim.toLiteral(string), 2);
        this.trace.trace("moveHandler: association == " + SkeletonSubscriptionShim.toLiteral(string2), 2);
        XDSParentElement xDSParentElement = xDSMoveElement.extractParentElement();
        String string3 = xDSParentElement.extractAssociationText();
        this.trace.trace("moveHandler:\tparent association == " + SkeletonSubscriptionShim.toLiteral(string3), 2);
    }

    private void appendDriverIdentityInfo(XDSCommandResultDocument xDSCommandResultDocument) {
        if (xDSCommandResultDocument != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<instance class-name=\"__driver_identification_class__\">");
            stringBuffer.append("<attr attr-name=\"driver-id\">");
            stringBuffer.append("<value type=\"string\">");
            stringBuffer.append(DRIVER_ID_VALUE);
            stringBuffer.append("</value>");
            stringBuffer.append("</attr>");
            stringBuffer.append("<attr attr-name=\"driver-version\">");
            stringBuffer.append("<value type=\"string\">");
            stringBuffer.append("3.5.2");
            stringBuffer.append("</value>");
            stringBuffer.append("</attr>");
            stringBuffer.append("<attr attr-name=\"min-activation-version\">");
            stringBuffer.append("<value type=\"string\">");
            stringBuffer.append(DRIVER_MIN_ACTIVATION_VERSION);
            stringBuffer.append("</value>");
            stringBuffer.append("</attr>");
            stringBuffer.append("<attr attr-name=\"query-ex-supported\">");
            stringBuffer.append("<value type=\"state\">false</value>");
            stringBuffer.append("</attr>");
            stringBuffer.append("</instance>");
            XDSUtil.appendXML((Element)xDSCommandResultDocument.domIOElement(), (String)stringBuffer.toString());
        }
    }

    void shutdown() {
        this.trace.trace("shutdown", 1);
        this.disconnect();
    }

    void appendStateInfo(StateDocument stateDocument) {
        if (stateDocument != null) {
            String string = "<init-params><subscriber-state><current-association>" + String.valueOf(this.currentAssociation) + "</current-association>" + "</subscriber-state>" + "</init-params>";
            XDSUtil.appendXML((Element)stateDocument.domIOElement(), (String)string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

