/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.Errors;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestDecoder;
import com.novell.nds.dirxml.vrtest.VRTestEncoder;
import com.novell.nds.dirxml.vrtest.VRTestEvent;
import com.novell.nds.dirxml.vrtest.VRTestEventType;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestHandle;
import com.novell.nds.dirxml.vrtest.VRTestInputStream;
import com.novell.nds.dirxml.vrtest.VRTestOutputStream;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class VRTestAPI
implements Constants,
VRTestConstants {
    private static final String LOCAL_HOST = "localhost";
    private static final int PORT_OFFSET = 1;
    private int commandResponsePort;
    private int eventPort;
    private String host;
    private Socket commandResponseChannel = null;
    private Socket eventChannel = null;
    private Object commandResponseMutex = new short[0];
    public final Object findMutex = new short[0];
    public final Object connectMutex = new short[0];
    private VRTestOutputStream toServer = null;
    private VRTestInputStream fromServer = null;
    private VRTestInputStream events = null;
    private VRTestSchema schema = null;

    private void setPorts(int basePort) throws VRTestException {
        if (VRTestAPI.isInvalidPortNum(basePort)) {
            throw new VRTestException(Errors.ParamOutOfRange("basePort", String.valueOf(basePort)));
        }
        this.commandResponsePort = basePort;
        this.eventPort = basePort + 1;
    }

    private static boolean isInvalidPortNum(int portNum) {
        return portNum < 0 && portNum > 65534;
    }

    private boolean hostLookupRequired(String hostName) {
        return hostName == null || hostName.equalsIgnoreCase(LOCAL_HOST);
    }

    private void setHostName(String hostName) throws IOException {
        this.host = this.hostLookupRequired(hostName) ? InetAddress.getLocalHost().getHostName() : hostName;
    }

    private String sendCommand(String encodedCommand) throws IOException {
        Object object = this.commandResponseMutex;
        synchronized (object) {
            if (this.commandResponseChannel == null) {
                throw new IOException("Session closed.");
            }
            this.toServer.write(encodedCommand);
            String string = this.fromServer.read();
            return string;
        }
    }

    public long create(String className, VRTestAttributeList attributes) throws VRTestException, IOException {
        if (className == null) {
            throw new IllegalArgumentException(Errors.NullParam("className"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(Errors.NullParam("attributes"));
        }
        VRTestEncoder encoder = new VRTestEncoder();
        encoder.encodeCommand("CREATE");
        encoder.encodeString(className);
        encoder.encodeAttributes(attributes);
        String encodedResponse = this.sendCommand(encoder.getEncoding());
        VRTestDecoder decoder = new VRTestDecoder(encodedResponse);
        String type = decoder.getReturnType();
        if (type == "ERROR") {
            decoder.getString();
            throw new VRTestException(decoder.getString());
        }
        if (type == "HANDLE") {
            long handle = decoder.getHandle();
            if (VRTestHandle.IsInvalid(handle)) {
                throw new VRTestException(Errors.BadHandle(handle));
            }
            return handle;
        }
        throw new VRTestException(Errors.UnsupportedReturnType(type));
    }

    public void deleteByHandle(long handle) throws VRTestException, IOException {
        if (VRTestHandle.IsInvalid(handle)) {
            throw new VRTestException(Errors.BadHandle(handle));
        }
        VRTestEncoder encoder = new VRTestEncoder();
        encoder.encodeCommand("DELETE");
        encoder.encodeHandle(handle);
        String encodedResponse = this.sendCommand(encoder.getEncoding());
        VRTestDecoder decoder = new VRTestDecoder(encodedResponse);
        String type = decoder.getReturnType();
        if (type == "ERROR") {
            decoder.getString();
            throw new VRTestException(decoder.getString());
        }
        if (type != "ACK") {
            throw new VRTestException(Errors.UnsupportedReturnType(type));
        }
    }

    public void modifyByHandle(long handle, VRTestAttributeList attributes) throws VRTestException, IOException {
        if (VRTestHandle.IsInvalid(handle)) {
            throw new VRTestException(Errors.BadHandle(handle));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(Errors.NullParam("attributes"));
        }
        VRTestEncoder encoder = new VRTestEncoder();
        encoder.encodeCommand("MODIFY");
        encoder.encodeHandle(handle);
        encoder.encodeAttributes(attributes);
        String encodedResponse = this.sendCommand(encoder.getEncoding());
        VRTestDecoder decoder = new VRTestDecoder(encodedResponse);
        String type = decoder.getReturnType();
        if (type == "ERROR") {
            decoder.getString();
            throw new VRTestException(decoder.getString());
        }
        if (type == "HANDLE") {
            long receiveHandle = decoder.getHandle();
            if (handle != receiveHandle) {
                throw new VRTestException("Handle mismatch.");
            }
            return;
        }
        throw new VRTestException(Errors.UnsupportedReturnType(type));
    }

    public int getClientID() throws VRTestException, IOException {
        VRTestEncoder encoder = new VRTestEncoder();
        encoder.encodeCommand("GETCLIENTID");
        String encodedResponse = this.sendCommand(encoder.getEncoding());
        VRTestDecoder decoder = new VRTestDecoder(encodedResponse);
        String type = decoder.getReturnType();
        if (type == "ERROR") {
            decoder.getString();
            throw new VRTestException(decoder.getString());
        }
        if (type == "CLIENTID") {
            return decoder.getID();
        }
        throw new VRTestException(Errors.UnsupportedReturnType(type));
    }

    public VRTestEvent waitForEvent() throws VRTestException, IOException {
        VRTestDecoder decoder = new VRTestDecoder(this.events.read());
        VRTestEventType type = decoder.getEventType();
        long handle = decoder.getHandle();
        String className = decoder.getString();
        VRTestAttributeList attributes = decoder.getAttributes();
        int id = decoder.getID();
        return new VRTestEvent(type, handle, className, attributes, id);
    }

    public VRTestAttributeList getAttributesByHandle(long handle) throws VRTestException, IOException {
        if (VRTestHandle.IsInvalid(handle)) {
            throw new VRTestException(Errors.BadHandle(handle));
        }
        VRTestEncoder encoder = new VRTestEncoder();
        encoder.encodeCommand("GETATTRIBUTES");
        encoder.encodeHandle(handle);
        encoder.encodeAttributes(null);
        String encodedResponse = this.sendCommand(encoder.getEncoding());
        VRTestDecoder decoder = new VRTestDecoder(encodedResponse);
        String type = decoder.getReturnType();
        if (type == "ERROR") {
            return VRTestAttributeList.EMPTY;
        }
        if (type == "ATTRIBUTES") {
            if (handle != decoder.getHandle()) {
                throw new VRTestException("Handle mismatch.");
            }
            decoder.getString();
            return decoder.getAttributes();
        }
        throw new VRTestException(Errors.UnsupportedReturnType(type));
    }

    public VRTestSchema getSchema() throws VRTestException, IOException {
        if (this.schema == null) {
            this.getSchemaFromServer();
        }
        return this.schema;
    }

    private void getSchemaFromServer() throws VRTestException, IOException {
        VRTestEncoder encoder = new VRTestEncoder();
        encoder.encodeCommand("GETSCHEMA");
        String encodedResponse = this.sendCommand(encoder.getEncoding());
        VRTestDecoder decoder = new VRTestDecoder(encodedResponse);
        String type = decoder.getReturnType();
        if (type == "ERROR") {
            decoder.getString();
            throw new VRTestException(decoder.getString());
        }
        if (type != "SCHEMA") {
            throw new VRTestException(Errors.UnsupportedReturnType(type));
        }
        this.schema = new VRTestSchema(decoder.getString());
    }

    public long findFirst(String className, VRTestAttributeList filter) throws VRTestException, IOException {
        if (className == null) {
            throw new IllegalArgumentException(Errors.NullParam("className"));
        }
        VRTestEncoder encoder = new VRTestEncoder();
        encoder.encodeCommand("FINDFIRST");
        encoder.encodeString(className);
        encoder.encodeAttributes(filter);
        String encodedResponse = this.sendCommand(encoder.getEncoding());
        VRTestDecoder decoder = new VRTestDecoder(encodedResponse);
        String type = decoder.getReturnType();
        if (type == "ERROR") {
            decoder.getString();
            throw new VRTestException(decoder.getString());
        }
        if (type == "HANDLE") {
            return decoder.getHandle();
        }
        throw new VRTestException(Errors.UnsupportedReturnType(type));
    }

    public long findNext() throws VRTestException, IOException {
        VRTestEncoder encoder = new VRTestEncoder();
        encoder.encodeCommand("FINDNEXT");
        String encodedResponse = this.sendCommand(encoder.getEncoding());
        VRTestDecoder decoder = new VRTestDecoder(encodedResponse);
        String type = decoder.getReturnType();
        if (type == "ERROR") {
            decoder.getString();
            throw new VRTestException(decoder.getString());
        }
        if (type == "HANDLE") {
            return decoder.getHandle();
        }
        throw new VRTestException(Errors.UnsupportedReturnType(type));
    }

    public void startSession(String hostName, int port) throws VRTestException, IOException {
        if (this.commandResponseChannel == null) {
            Object object = this.commandResponseMutex;
            synchronized (object) {
                this.setHostName(hostName);
                this.setPorts(port);
                this.commandResponseChannel = new Socket(this.host, this.commandResponsePort);
                this.eventChannel = new Socket(this.host, this.eventPort);
                this.fromServer = new VRTestInputStream(this.commandResponseChannel.getInputStream());
                this.toServer = new VRTestOutputStream(this.commandResponseChannel.getOutputStream());
                this.events = new VRTestInputStream(this.eventChannel.getInputStream());
            }
        }
    }

    public void endSession() {
        if (this.commandResponseChannel != null) {
            try {
                try {
                    Object object = this.commandResponseMutex;
                    synchronized (object) {
                        this.commandResponseChannel.close();
                    }
                    Object var4_5 = null;
                    this.commandResponseChannel = null;
                }
                catch (IOException io) {
                    Object var4_6 = null;
                    this.commandResponseChannel = null;
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.commandResponseChannel = null;
                throw throwable;
            }
            try {
                try {
                    this.eventChannel.close();
                }
                catch (IOException io) {
                    Object var6_10 = null;
                    this.eventChannel = null;
                }
                Object var6_9 = null;
                this.eventChannel = null;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                this.eventChannel = null;
                throw throwable;
            }
        }
    }
}

