/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.Errors;
import com.novell.nds.dirxml.vrtest.VRTestAction;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class VRTestAttributeList
implements Constants,
VRTestConstants {
    public static final VRTestAttributeList EMPTY = new VRTestAttributeList();
    private LinkedList removeAttrs = null;
    private List attributes = new Vector();

    public boolean isEmpty() {
        return this.attributes.size() == 0;
    }

    public void removeCurrent() {
        ListIterator iterator = this.removeAttrs.listIterator();
        while (iterator.hasNext()) {
            VRTestAttribute attr = (VRTestAttribute)iterator.next();
            this.attributes.remove(attr);
        }
        this.removeAttrs = null;
    }

    public VRTestAttribute getPath() {
        return this.getAttributeByName("Object Path");
    }

    public VRTestAttribute getID() {
        return this.getAttributeByName("Unique Id");
    }

    public VRTestAttribute getAttributeByName(String name) {
        int size = this.attributes.size();
        int index = 0;
        while (index < size) {
            VRTestAttribute attribute = (VRTestAttribute)this.attributes.get(index);
            if (name.compareTo(attribute.getName()) == 0) {
                this.removeAttrs = new LinkedList();
                this.removeAttrs.add(attribute);
                return attribute;
            }
            ++index;
        }
        return null;
    }

    public LinkedList getAttribute(VRTestAttributeSchema attributeSchema) throws VRTestException {
        if (attributeSchema == null) {
            throw new IllegalArgumentException(Errors.NullParam("attributeSchema"));
        }
        LinkedList<VRTestAttribute> matches = null;
        int size = this.attributes.size();
        int index = 0;
        while (index < size) {
            VRTestAttribute attribute = (VRTestAttribute)this.attributes.get(index);
            if (attributeSchema.hasName(attribute.getName())) {
                if (matches == null) {
                    matches = new LinkedList<VRTestAttribute>();
                }
                matches.add(attribute);
            }
            ++index;
        }
        this.removeAttrs = matches;
        return matches;
    }

    public List attributes() {
        return this.attributes;
    }

    public void addAttribute(String name, String value, VRTestAction action) throws VRTestException {
        this.attributes.add(new VRTestAttribute(name, value, action));
    }

    public void addAttribute(VRTestAttribute attribute) throws VRTestException {
        if (attribute == null) {
            throw new IllegalArgumentException(Errors.NullParam("attribute"));
        }
        this.attributes.add(attribute);
    }

    public void clear() {
        this.attributes = new Vector();
    }
}

