/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.VRTestAttributeKeyword;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestIntegerToken;
import com.novell.nds.dirxml.vrtest.VRTestKeyword;
import com.novell.nds.dirxml.vrtest.VRTestKeywordToken;
import com.novell.nds.dirxml.vrtest.VRTestStringToken;
import com.novell.nds.dirxml.vrtest.VRTestToken;
import com.novell.nds.dirxml.vrtest.VRTestTokenizer;

class VRTestAttributeSchemaParser
implements Constants {
    private boolean gotName;
    private VRTestTokenizer tokenizer;
    private VRTestAttributeSchema attributeSchema;

    VRTestAttributeSchemaParser(VRTestAttributeSchema anAttributeSchema, VRTestTokenizer aTokenizer) {
        this.attributeSchema = anAttributeSchema;
        this.tokenizer = aTokenizer;
        this.gotName = false;
    }

    void parse() throws VRTestException {
        boolean done = false;
        do {
            VRTestToken token;
            if ((token = this.tokenizer.peekNextToken()) instanceof VRTestKeywordToken) {
                VRTestKeyword keyword = ((VRTestKeywordToken)token).getKeyword();
                if (keyword instanceof VRTestAttributeKeyword) {
                    this.tokenizer.consumeToken();
                    this.handleKeyword(keyword);
                    continue;
                }
                done = true;
                continue;
            }
            if (token == null) {
                done = true;
                continue;
            }
            throw new VRTestException("Parse Error!  Expecting keyword.");
        } while (!done);
        if (!this.gotName) {
            throw new VRTestException("Parse Error!  No attribute schema name.");
        }
    }

    private void handleKeyword(VRTestKeyword keyword) throws VRTestException {
        if (keyword == VRTestKeyword.NAME) {
            this.gotName = true;
            this.handleName();
        } else if (keyword == VRTestKeyword.MAXLENGTH) {
            this.handleMaxLength();
        } else {
            this.handleBoolean(keyword);
        }
    }

    private void handleName() throws VRTestException {
        VRTestToken token = this.tokenizer.getNextToken();
        if (!(token instanceof VRTestStringToken)) {
            throw new VRTestException("Parse Error!  Expecting string.");
        }
        this.attributeSchema.setName(((VRTestStringToken)token).getString());
    }

    private void handleMaxLength() throws VRTestException {
        VRTestToken token = this.tokenizer.getNextToken();
        if (!(token instanceof VRTestIntegerToken)) {
            throw new VRTestException("Parse Error!  Expecting integer.");
        }
        this.attributeSchema.setMaxLength(((VRTestIntegerToken)token).getInt());
    }

    private void handleBoolean(VRTestKeyword keyword) throws VRTestException {
        boolean parameter = this.tokenizer.getBooleanValue();
        if (keyword == VRTestKeyword.REQUIRED) {
            this.attributeSchema.setRequired(parameter);
        } else if (keyword == VRTestKeyword.MULTIVALUED) {
            this.attributeSchema.setMultiValued(parameter);
        } else if (keyword == VRTestKeyword.INDEXED) {
            this.attributeSchema.setIndexed(parameter);
        } else if (keyword == VRTestKeyword.CASESENSITIVE) {
            this.attributeSchema.setCaseSensitive(parameter);
        } else if (keyword == VRTestKeyword.UNIQUE) {
            this.attributeSchema.setUnique(parameter);
        } else if (keyword == VRTestKeyword.READONLY) {
            this.attributeSchema.setReadOnly(parameter);
        }
    }
}

