/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.Errors;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchemaParser;
import com.novell.nds.dirxml.vrtest.VRTestClassKeyword;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestKeyword;
import com.novell.nds.dirxml.vrtest.VRTestKeywordToken;
import com.novell.nds.dirxml.vrtest.VRTestStringToken;
import com.novell.nds.dirxml.vrtest.VRTestToken;
import com.novell.nds.dirxml.vrtest.VRTestTokenizer;

class VRTestClassSchemaParser
implements Constants {
    private boolean gotName;
    private VRTestTokenizer tokenizer;
    private VRTestClassSchema classSchema;

    VRTestClassSchemaParser(VRTestClassSchema aClassSchema, VRTestTokenizer aTokenizer) throws VRTestException {
        this.classSchema = aClassSchema;
        this.tokenizer = aTokenizer;
        this.gotName = false;
    }

    void parse() throws VRTestException {
        boolean done = false;
        do {
            VRTestToken token;
            if ((token = this.tokenizer.peekNextToken()) instanceof VRTestKeywordToken) {
                VRTestKeyword keyword = ((VRTestKeywordToken)token).getKeyword();
                if (keyword instanceof VRTestClassKeyword) {
                    this.tokenizer.consumeToken();
                    this.handleKeyword(keyword);
                    continue;
                }
                done = true;
                continue;
            }
            if (token == null) {
                done = true;
                continue;
            }
            throw new VRTestException("Parse Error!  Expecting keyword.");
        } while (!done);
        if (!this.gotName) {
            throw new VRTestException("Parse Error!  No class schema name.");
        }
        if (this.classSchema.getNamingAttributeSchema() == null) {
            throw new VRTestException(Errors.NoNamingAttributeSchema(this.classSchema.toString()));
        }
    }

    private void handleKeyword(VRTestKeyword keyword) throws VRTestException {
        if (keyword == VRTestKeyword.NAME) {
            this.gotName = true;
            this.handleName();
        } else if (keyword == VRTestKeyword.ATTRIBUTE) {
            this.handleAttribute();
        } else {
            this.handleBoolean(keyword);
        }
    }

    private void handleName() throws VRTestException {
        VRTestToken token = this.tokenizer.getNextToken();
        if (!(token instanceof VRTestStringToken)) {
            throw new VRTestException("Parse Error!  Expecting string.");
        }
        this.classSchema.setName(((VRTestStringToken)token).getString());
    }

    private void handleAttribute() throws VRTestException {
        VRTestAttributeSchema attributeSchema = new VRTestAttributeSchema();
        attributeSchema.setCaseSensitive(this.classSchema.isCaseSensitive());
        VRTestAttributeSchemaParser attributeParser = new VRTestAttributeSchemaParser(attributeSchema, this.tokenizer);
        attributeParser.parse();
        this.classSchema.addAttributeSchema(attributeSchema);
    }

    private void handleBoolean(VRTestKeyword keyword) throws VRTestException {
        boolean parameter = this.tokenizer.getBooleanValue();
        if (keyword == VRTestKeyword.CONTAINER) {
            this.classSchema.setContainer(parameter);
        } else if (keyword == VRTestKeyword.CASESENSITIVE) {
            this.classSchema.setCaseSensitive(parameter);
        }
    }
}

