/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.Errors;
import com.novell.nds.dirxml.vrtest.VRTestAction;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestCoder;
import com.novell.nds.dirxml.vrtest.VRTestEventType;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestReturnType;

class VRTestDecoder
extends VRTestCoder
implements Constants {
    protected static final int AVG_STRING_LEN_CHARS = 15;
    protected String encoding;
    protected int index;
    protected int length;

    private VRTestDecoder() {
    }

    VRTestDecoder(String encodedString) {
        this.encoding = encodedString;
        this.length = encodedString.length();
        this.index = 0;
    }

    int getInt() throws VRTestException {
        String intString = this.getString();
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            throw new VRTestException("Parse Error!  Expecting integer.");
        }
    }

    long getLong() throws VRTestException {
        String longString = this.getString();
        try {
            return Long.parseLong(longString);
        }
        catch (NumberFormatException e) {
            throw new VRTestException("Parse Error!  Expecting long.");
        }
    }

    String getReturnType() throws VRTestException {
        String returnType = this.getString();
        returnType = VRTestReturnType.lookupType(returnType);
        return returnType;
    }

    private boolean isInvalidIndex(int index) {
        return index < 0 || index > this.length;
    }

    private boolean isEscaped(int index) {
        if (index >= 2) {
            return this.encoding.charAt(index - 1) == '\\' && this.encoding.charAt(index - 2) != '\\';
        }
        if (index == 1) {
            return this.encoding.charAt(index - 1) == '\\';
        }
        return false;
    }

    private int findCharIndex(char character) throws VRTestException {
        int charIndex = this.index;
        while (charIndex < this.length) {
            if ((charIndex = this.encoding.indexOf(character, charIndex)) == -1) {
                throw new VRTestException(Errors.ExpectingChar(character));
            }
            if (!this.isEscaped(charIndex)) {
                return charIndex;
            }
            ++charIndex;
        }
        throw new VRTestException(Errors.ExpectingChar(character));
    }

    String getString() throws VRTestException {
        StringBuffer buffer = new StringBuffer(15);
        int currentIndex = this.findCharIndex('{') + 1;
        boolean escaped = false;
        char currentChar = 'c';
        while (currentIndex < this.length) {
            if ((currentChar = (char)this.encoding.charAt(currentIndex++)) == '}') {
                if (escaped) continue;
                break;
            }
            if (currentChar == '\\') {
                if (!escaped) {
                    escaped = true;
                    buffer.append(currentChar);
                    continue;
                }
                escaped = false;
                continue;
            }
            escaped = false;
            buffer.append(currentChar);
        }
        if (currentChar != '}') {
            throw new VRTestException(Errors.ExpectingChar('}'));
        }
        this.index = currentIndex;
        return buffer.toString();
    }

    private boolean areRemainingChars() {
        return this.index < this.length;
    }

    private boolean outOfChars() {
        return this.index >= this.length;
    }

    private char getNextChar() {
        return this.encoding.charAt(this.index++);
    }

    private char getCurrentChar() {
        return this.encoding.charAt(this.index);
    }

    private void stripWhiteSpaces() {
        while (this.areRemainingChars() && Character.isWhitespace(this.getCurrentChar())) {
            this.getNextChar();
        }
    }

    /*
     * Unable to fully structure code
     */
    VRTestAttributeList getAttributes() throws VRTestException {
        attributes = new VRTestAttributeList();
        this.index = this.findCharIndex('{') + 1;
        character = 97;
        if (true) ** GOTO lbl9
        do {
            attribute = this.getAttribute();
            attributes.addAttribute(attribute);
            this.stripWhiteSpaces();
lbl9:
            // 2 sources

            if (!this.areRemainingChars()) break;
            v0 = this.getCurrentChar();
            character = v0;
        } while (v0 != '}');
        if (character != 125) {
            throw new VRTestException(Errors.ExpectingChar('}'));
        }
        this.getNextChar();
        return attributes;
    }

    private VRTestAttribute getAttribute() throws VRTestException {
        this.index = this.findCharIndex('{') + 1;
        String name = this.getString();
        String value = this.getString();
        VRTestAction action = this.getAction();
        this.index = this.findCharIndex('}') + 1;
        return new VRTestAttribute(name, value, action);
    }

    private VRTestAction getAction() throws VRTestException {
        return VRTestAction.lookupAction(this.getString());
    }

    long getHandle() throws VRTestException {
        return this.getLong();
    }

    VRTestEventType getEventType() throws VRTestException {
        return VRTestEventType.lookupType(this.getString());
    }

    int getID() throws VRTestException {
        return this.getInt();
    }
}

