/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.VRTestAction;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestCoder;
import java.util.ListIterator;

class VRTestEncoder
extends VRTestCoder
implements Constants {
    protected static final int DEFAULT_BUFFER_SIZE_CHARS = 48;
    private StringBuffer buffer = new StringBuffer(48);

    static boolean isReservedChar(char c) {
        return c == '{' || c == '}' || c == '\\';
    }

    VRTestEncoder() {
    }

    void encodeCommand(String command) {
        this.encodeString(command.toString());
    }

    void encodeLong(long lng) {
        this.encodeString(String.valueOf(lng));
    }

    void encodeString(String string) {
        this.buffer.append('{');
        if (string != null) {
            int stringLen = string.length();
            int i = 0;
            while (i < stringLen) {
                char c = string.charAt(i);
                if (VRTestEncoder.isReservedChar(c)) {
                    this.buffer.append('\\');
                }
                this.buffer.append(c);
                ++i;
            }
        }
        this.buffer.append('}');
    }

    void encodeHandle(long handle) {
        this.encodeLong(handle);
    }

    void encodeAttributes(VRTestAttributeList attributes) {
        this.buffer.append('{');
        if (attributes != null) {
            ListIterator a = attributes.attributes().listIterator();
            while (a.hasNext()) {
                VRTestAttribute attribute = (VRTestAttribute)a.next();
                String name = attribute.getName();
                String value = attribute.getValue();
                VRTestAction action = attribute.getAction();
                this.buffer.append('{');
                this.encodeString(name);
                this.encodeString(value);
                this.encodeString(action.toString());
                this.buffer.append('}');
            }
        }
        this.buffer.append('}');
    }

    String getEncoding() {
        return this.buffer.toString();
    }
}

