/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.VRTestStream;
import java.io.IOException;
import java.io.InputStream;

class VRTestInputStream
extends VRTestStream
implements Constants {
    private InputStream stream;

    private int nextByte() throws IOException {
        int b = this.stream.read();
        if (b == -1) {
            throw new IOException("End of stream");
        }
        return b;
    }

    VRTestInputStream(InputStream inStream) {
        this.stream = inStream;
    }

    String read() throws IOException {
        int noOfBytesInBody = this.getHeaderVal();
        String encodedResponse = this.getBody(noOfBytesInBody);
        return encodedResponse;
    }

    private int getHeaderVal() throws IOException {
        int noOfBytesInBody = this.nextByte() << 24;
        noOfBytesInBody |= this.nextByte() << 16;
        noOfBytesInBody |= this.nextByte() << 8;
        return noOfBytesInBody |= this.nextByte();
    }

    private String getBody(int noOfBytesInBody) throws IOException {
        StringBuffer buffer = new StringBuffer(noOfBytesInBody / 2);
        int totalBytesRead = 0;
        while (totalBytesRead < noOfBytesInBody) {
            int highByte = this.nextByte();
            int lowByte = this.nextByte();
            highByte = highByte << 8 | lowByte;
            buffer.append((char)highByte);
            totalBytesRead += 2;
        }
        return buffer.toString();
    }
}

