/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.VRTestStream;
import java.io.IOException;
import java.io.OutputStream;

class VRTestOutputStream
extends VRTestStream {
    private OutputStream stream;

    VRTestOutputStream(OutputStream outStream) {
        this.stream = outStream;
    }

    void write(String encodedMessage) throws IOException {
        int noOfCharsInMessage = encodedMessage.length();
        int noOfBytesInBody = noOfCharsInMessage * 2;
        int noOfBytesInPacket = noOfBytesInBody + 4;
        byte[] packet = new byte[noOfBytesInPacket];
        this.setHeader(packet, noOfBytesInBody);
        this.setBody(packet, encodedMessage, noOfCharsInMessage);
        this.stream.write(packet);
    }

    private void setHeader(byte[] packet, int noOfBytesInBody) {
        packet[0] = (byte)(noOfBytesInBody >> 24);
        packet[1] = (byte)(noOfBytesInBody >> 16);
        packet[2] = (byte)(noOfBytesInBody >> 8);
        packet[3] = (byte)noOfBytesInBody;
    }

    private void setBody(byte[] packet, String message, int noOfCharsInMessage) {
        int p = 4;
        int m = 0;
        while (m < noOfCharsInMessage) {
            char c = message.charAt(m);
            packet[p++] = (byte)(c >> 8);
            packet[p++] = (byte)c;
            ++m;
        }
    }
}

