/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.Errors;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestMetaData;
import com.novell.nds.dirxml.vrtest.VRTestSchemaParser;
import com.novell.nds.dirxml.vrtest.VRTestTokenizer;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class VRTestSchema
implements Constants,
VRTestConstants,
VRTestMetaData {
    private String name;
    private boolean hierarchical;
    private boolean uniqueIDs;
    private boolean subtreeDelete;
    private boolean caseSensitive;
    private List classSchemas;

    private VRTestSchema() {
    }

    public VRTestSchema(String serializedSchema) throws VRTestException {
        if (serializedSchema == null) {
            throw new IllegalArgumentException(Errors.NullParam("streamedSchema"));
        }
        this.hierarchical = false;
        this.uniqueIDs = true;
        this.subtreeDelete = false;
        this.caseSensitive = true;
        this.classSchemas = new Vector();
        VRTestTokenizer tokenizer = new VRTestTokenizer(serializedSchema);
        VRTestSchemaParser schemaParser = new VRTestSchemaParser(this, tokenizer);
        schemaParser.parse();
        this.addObjectPaths();
        this.addUniqueIDs();
    }

    void setHierarchical(boolean isHierarchical) {
        this.hierarchical = isHierarchical;
    }

    void setName(String nameValue) {
        this.name = nameValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHierarchical() {
        return this.hierarchical;
    }

    void setSubtreeDelete(boolean canSubtreeDelete) {
        this.subtreeDelete = canSubtreeDelete;
    }

    public boolean canSubtreeDelete() {
        return this.subtreeDelete;
    }

    void setUniqueIDs(boolean hasUniqueIDs) {
        this.uniqueIDs = hasUniqueIDs;
    }

    public boolean hasUniqueIDs() {
        return this.uniqueIDs;
    }

    void setCaseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void addClassSchema(VRTestClassSchema classSchema) {
        this.classSchemas.add(classSchema);
    }

    private void addObjectPaths() throws VRTestException {
        if (this.hierarchical) {
            VRTestAttributeSchema objectPath = new VRTestAttributeSchema();
            objectPath.setName("Object Path");
            objectPath.setMaxLength(2048);
            objectPath.setRequired(true);
            objectPath.setMultiValued(false);
            objectPath.setIndexed(true);
            objectPath.setUnique(false);
            objectPath.setCaseSensitive(this.caseSensitive);
            ListIterator c = this.classSchemas.listIterator();
            while (c.hasNext()) {
                VRTestClassSchema classSchema = (VRTestClassSchema)c.next();
                if (classSchema.getAttributeSchema("Object Path") != null) continue;
                classSchema.addAttributeSchema(objectPath);
            }
        }
    }

    private void addUniqueIDs() throws VRTestException {
        if (this.uniqueIDs) {
            VRTestAttributeSchema uniqueID = new VRTestAttributeSchema();
            uniqueID.setName("Unique Id");
            uniqueID.setMaxLength(10);
            uniqueID.setRequired(true);
            uniqueID.setMultiValued(false);
            uniqueID.setIndexed(true);
            uniqueID.setUnique(true);
            uniqueID.setCaseSensitive(false);
            uniqueID.setReadOnly(true);
            ListIterator c = this.classSchemas.listIterator();
            while (c.hasNext()) {
                VRTestClassSchema classSchema = (VRTestClassSchema)c.next();
                if (classSchema.getAttributeSchema("Unique Id") != null) continue;
                classSchema.addAttributeSchema(uniqueID);
            }
        }
    }

    public VRTestClassSchema getClassSchema(String someName) {
        if (someName == null) {
            return null;
        }
        ListIterator c = this.classSchemas.listIterator();
        while (c.hasNext()) {
            VRTestClassSchema classSchema = (VRTestClassSchema)c.next();
            if (!classSchema.equals(someName)) continue;
            return classSchema;
        }
        return null;
    }

    public List getClassSchemas() {
        return this.classSchemas;
    }
}

