/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchemaParser;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestKeyword;
import com.novell.nds.dirxml.vrtest.VRTestKeywordToken;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import com.novell.nds.dirxml.vrtest.VRTestStringToken;
import com.novell.nds.dirxml.vrtest.VRTestToken;
import com.novell.nds.dirxml.vrtest.VRTestTokenizer;

class VRTestSchemaParser
implements Constants {
    private VRTestSchema schema;
    private VRTestTokenizer tokenizer;

    VRTestSchemaParser(VRTestSchema aSchema, VRTestTokenizer aTokenizer) throws VRTestException {
        this.schema = aSchema;
        this.tokenizer = aTokenizer;
    }

    void parse() throws VRTestException {
        VRTestToken token = this.tokenizer.getNextToken();
        while (token != Constants.NO_MORE_TOKEN) {
            if (!(token instanceof VRTestKeywordToken)) {
                throw new VRTestException("Parse Error!  Expecting keyword.");
            }
            this.handleKeyword(((VRTestKeywordToken)token).getKeyword());
            token = this.tokenizer.getNextToken();
        }
    }

    private void handleKeyword(VRTestKeyword keyword) throws VRTestException {
        if (keyword == VRTestKeyword.SCHEMA) {
            this.handleName();
        } else if (keyword == VRTestKeyword.CLASS) {
            this.handleClass();
        } else {
            this.handleBoolean(keyword);
        }
    }

    private void handleName() throws VRTestException {
        VRTestToken token = this.tokenizer.getNextToken();
        if (!(token instanceof VRTestStringToken)) {
            throw new VRTestException("Parse Error!  Expecting string.");
        }
        this.schema.setName(((VRTestStringToken)token).getString());
    }

    private void handleClass() throws VRTestException {
        VRTestClassSchema classSchema = new VRTestClassSchema();
        classSchema.setCaseSensitive(this.schema.isCaseSensitive());
        VRTestClassSchemaParser classParser = new VRTestClassSchemaParser(classSchema, this.tokenizer);
        classParser.parse();
        this.schema.addClassSchema(classSchema);
    }

    private void handleBoolean(VRTestKeyword keyword) throws VRTestException {
        boolean parameter = this.tokenizer.getBooleanValue();
        if (keyword == VRTestKeyword.CASESENSITIVE) {
            this.schema.setCaseSensitive(parameter);
        } else if (keyword == VRTestKeyword.HIERARCHICAL) {
            this.schema.setHierarchical(parameter);
        } else if (keyword == VRTestKeyword.SUBTREEDELETE) {
            this.schema.setSubtreeDelete(parameter);
        } else if (keyword == VRTestKeyword.UNIQUEIDS) {
            this.schema.setUniqueIDs(parameter);
        }
    }
}

