/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.vrtest;

import com.novell.nds.dirxml.vrtest.Constants;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestIntegerToken;
import com.novell.nds.dirxml.vrtest.VRTestKeyword;
import com.novell.nds.dirxml.vrtest.VRTestKeywordToken;
import com.novell.nds.dirxml.vrtest.VRTestRealToken;
import com.novell.nds.dirxml.vrtest.VRTestStringToken;
import com.novell.nds.dirxml.vrtest.VRTestToken;

class VRTestTokenizer
implements Constants {
    private static final int AVG_NUM_SIZE_DIGITS = 10;
    private static final int AVG_STRING_SIZE_CHARS = 15;
    private int index;
    private int length;
    private String stream;
    private VRTestToken peekToken;

    VRTestTokenizer(String aStream) {
        this.stream = aStream;
        this.length = this.stream.length();
        this.index = 0;
        this.peekToken = null;
    }

    VRTestToken peekNextToken() throws VRTestException {
        if (this.peekToken == null) {
            this.peekToken = this.getNextToken();
            return this.peekToken;
        }
        return this.peekToken;
    }

    void consumeToken() {
        this.peekToken = null;
    }

    VRTestToken getNextToken() throws VRTestException {
        char character;
        if (this.peekToken != null) {
            VRTestToken token = this.peekToken;
            this.consumeToken();
            return token;
        }
        while (true) {
            if (this.outOfChars()) {
                return Constants.NO_MORE_TOKEN;
            }
            character = this.getNextChar();
            if (Character.isWhitespace(character)) continue;
            if (this.isNumberStart(character)) {
                return this.parseIntegerORReal(character);
            }
            if (VRTestTokenizer.isStringStart(character)) {
                return this.parseString();
            }
            if (this.isKeywordORIdentStart(character)) break;
        }
        return this.parseKeywordORIdent(character);
    }

    boolean getBooleanValue() throws VRTestException {
        VRTestToken token = this.getNextToken();
        if (!(token instanceof VRTestKeywordToken)) {
            throw new VRTestException("Parse Error!  Expecting keyword.");
        }
        VRTestKeyword keyword = ((VRTestKeywordToken)token).getKeyword();
        if (keyword == VRTestKeyword.TRUE) {
            return true;
        }
        if (keyword == VRTestKeyword.FALSE) {
            return false;
        }
        throw new VRTestException("Parse Error!  Expecting boolean keyword.");
    }

    private static boolean isStringStart(char character) {
        return character == '\"';
    }

    private boolean outOfChars() {
        return this.index == this.length;
    }

    private char getNextChar() {
        return this.stream.charAt(this.index++);
    }

    private void putBackChar() {
        --this.index;
    }

    private boolean isNumberStart(char character) {
        return Character.isDigit(character) || character == '.' || character == '-' || character == '+';
    }

    private boolean isKeywordORIdentStart(char character) {
        return Character.isLetter(character) || character == '_';
    }

    private VRTestToken parseIntegerORReal(char firstChar) throws VRTestException {
        boolean realNumber = firstChar == '.';
        boolean leadingZero = firstChar == '0';
        boolean hexNumber = false;
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(firstChar);
        while (!this.outOfChars()) {
            char character = this.getNextChar();
            if (character == '.') {
                if (realNumber || hexNumber) {
                    throw new VRTestException("Parse Error!  Illegal number.");
                }
                realNumber = true;
            } else if (this.isHexPrefix(leadingZero, character)) {
                hexNumber = true;
            } else if (this.isNonNumericChar(hexNumber, character)) {
                this.putBackChar();
                break;
            }
            buffer.append(character);
            leadingZero = false;
        }
        String numberString = buffer.toString();
        if (realNumber) {
            return new VRTestRealToken(numberString);
        }
        return new VRTestIntegerToken(numberString);
    }

    private int getRadix(boolean hexNumber) {
        if (hexNumber) {
            return 16;
        }
        return 10;
    }

    private boolean isHexPrefix(boolean leadingZero, char character) {
        return leadingZero && (character == 'x' || character == 'X');
    }

    private boolean isEscapeChar(boolean lastCharWasEscape, char character) {
        return character == '\\' && !lastCharWasEscape;
    }

    private boolean isIdentORKeywordChar(char character) {
        return Character.isLetterOrDigit(character) || character == '_';
    }

    private boolean isEndQuote(boolean lastCharWasEscape, char character) {
        return character == '\"' && !lastCharWasEscape;
    }

    private boolean isNonNumericChar(boolean hexNumber, char character) {
        return (!hexNumber || !Character.isLetter(character)) && !Character.isDigit(character);
    }

    private VRTestToken parseString() {
        StringBuffer buffer = new StringBuffer(15);
        boolean lastCharWasEscape = false;
        while (!this.outOfChars()) {
            char character = this.getNextChar();
            if (this.isEscapeChar(lastCharWasEscape, character)) {
                lastCharWasEscape = true;
                continue;
            }
            if (this.isEndQuote(lastCharWasEscape, character)) break;
            buffer.append(character);
            lastCharWasEscape = false;
        }
        return new VRTestStringToken(buffer.toString());
    }

    private VRTestToken parseKeywordORIdent(char firstChar) throws VRTestException {
        StringBuffer buffer = new StringBuffer(15);
        buffer.append(firstChar);
        boolean done = false;
        while (!done && !this.outOfChars()) {
            char character = this.getNextChar();
            if (this.isIdentORKeywordChar(character)) {
                buffer.append(character);
                continue;
            }
            this.putBackChar();
            done = true;
        }
        VRTestKeyword keyword = VRTestKeyword.getKeyword(buffer.toString());
        if (keyword == null) {
            throw new VRTestException("Parse Error!  Identifiers unsupported.");
        }
        return new VRTestKeywordToken(keyword);
    }
}

