/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.ConstraintGroup;
import com.novell.nds.dirxml.driver.xds.EnumConstraint;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;

class BooleanConstraint
extends Constraint {
    public static final BooleanConstraint BOOLEAN;
    private static final ConstraintGroup TRUE;
    private static final ConstraintGroup FALSE;
    private Constraint trueConstraint = TRUE;
    private Constraint falseConstraint = FALSE;

    Boolean parse(Parameter parameter, String string) {
        if (string == null) {
            return null;
        }
        if (this.isTrue(parameter, string)) {
            return Boolean.TRUE;
        }
        if (this.isFalse(parameter, string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    boolean isTrue(Parameter parameter, String string) {
        return this.trueConstraint.isValid(parameter, string);
    }

    boolean isFalse(Parameter parameter, String string) {
        return this.falseConstraint.isValid(parameter, string);
    }

    boolean isValid(Parameter parameter, String string) {
        return this.isTrue(parameter, string) || this.isFalse(parameter, string);
    }

    String getLegalValues() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.trueConstraint.getLegalValues());
        stringBuffer.append(", ");
        stringBuffer.append(this.falseConstraint.getLegalValues());
        return stringBuffer.toString();
    }

    static {
        ConstraintGroup constraintGroup = new ConstraintGroup();
        EnumConstraint enumConstraint = new EnumConstraint();
        enumConstraint.addLiterals(new String[]{"y", "yes", "t", "true", "on"});
        constraintGroup.add(enumConstraint);
        RangeConstraint rangeConstraint = new RangeConstraint(1L, 1L);
        constraintGroup.add(rangeConstraint);
        constraintGroup.setConstant();
        TRUE = constraintGroup;
        constraintGroup = new ConstraintGroup();
        enumConstraint = new EnumConstraint();
        enumConstraint.addLiterals(new String[]{"n", "no", "f", "false", "off"});
        constraintGroup.add(enumConstraint);
        rangeConstraint = new RangeConstraint(1L, 1L);
        rangeConstraint.setNOT();
        constraintGroup.add(rangeConstraint);
        constraintGroup.setConstant();
        FALSE = constraintGroup;
        BooleanConstraint booleanConstraint = new BooleanConstraint();
        booleanConstraint.setConstant();
        BOOLEAN = booleanConstraint;
    }
}

