/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.CaseInsensitiveComparator;
import com.novell.nds.dirxml.driver.xds.CaseSensitiveComparator;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EnumConstraint
extends Constraint {
    public static final Comparator CASE_SENSITIVE = new CaseSensitiveComparator();
    public static final Comparator CASE_INSENSITIVE;
    private static final Comparator DEFAULT_COMP;
    private static final boolean DEFAULT_NOT = false;
    private List enum;
    private Comparator comparator;

    public EnumConstraint() {
        this.not = false;
        this.setComparator(DEFAULT_COMP);
        this.setEnum();
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private void setEnum() {
        this.enum = new LinkedList();
    }

    public void setComparator(Comparator comparator) {
        Lib.CheckParam(comparator, "someComparator");
        this.comparator = comparator;
    }

    public void addLiteral(String string) {
        this.checkConstant();
        Lib.CheckParam(string, "value");
        this.enum.add(string);
    }

    public void addLiterals(String[] stringArray) {
        this.checkConstant();
        Lib.CheckParam(stringArray, "someValues");
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                this.enum.add(string);
            }
            ++n;
        }
    }

    boolean isValid(Parameter parameter, String string) {
        return string == null ? true : this.isValid(string, this.not);
    }

    private boolean isValid(String string, boolean bl) {
        ListIterator listIterator = this.enum.listIterator();
        while (listIterator.hasNext()) {
            if (this.comparator.compare((String)listIterator.next(), string) != 0) continue;
            return !bl;
        }
        return bl;
    }

    String getLegalValues() {
        StringBuffer stringBuffer = new StringBuffer(48);
        if (this.not) {
            stringBuffer.append("not");
        }
        boolean bl = true;
        ListIterator listIterator = this.enum.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append("'" + string + "'");
        }
        return stringBuffer.toString();
    }

    static {
        DEFAULT_COMP = CASE_INSENSITIVE = new CaseInsensitiveComparator();
    }
}

