/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.BooleanConstraint;
import com.novell.nds.dirxml.driver.xds.CharConstraint;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.IntConstraint;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LogicalOp;
import com.novell.nds.dirxml.driver.xds.LongConstraint;
import com.novell.nds.dirxml.driver.xds.ParamElement;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Parameter
implements Comparable {
    private static final boolean DEFAULT_REQUIRED = false;
    private static final boolean DEFAULT_CONSTANT = false;
    private static final LongConstraint LONG = new LongConstraint();
    private static final IntConstraint INT = new IntConstraint();
    private static final LogicalOp OP = LogicalOp.AND;
    private String tagName;
    private String description;
    private DataType type;
    private Object value;
    private List constraints;
    private ParamElement param;
    private boolean contentSensitive;
    private boolean required;
    private boolean constant;
    private BooleanConstraint bool;
    private HashMap constraintMap;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$RangeConstraint;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$EnumConstraint;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$BooleanConstraint;

    private void init() {
        this.param = null;
        this.bool = null;
        this.constraints = new LinkedList();
        this.required = false;
        this.constant = false;
        this.constraintMap = new HashMap();
        this.description = null;
    }

    public Parameter(String string, String string2, DataType dataType) {
        Lib.CheckParam(string, "someTagName");
        Lib.CheckParam(dataType, "someType");
        this.init();
        this.tagName = string;
        this.description = string;
        this.setSensitive();
        this.setType(dataType);
        this.setDefault(string2);
    }

    private void setSensitive() {
        this.contentSensitive = "password".compareTo(this.tagName) == 0;
    }

    public void setContentSensitive() {
        this.contentSensitive = true;
    }

    public boolean isContentSensitive() {
        return this.contentSensitive;
    }

    private void checkConstraints(Constraint constraint) {
        if (constraint.isContainer()) {
            ListIterator listIterator = constraint.getConstraints().listIterator();
            while (listIterator.hasNext()) {
                this.checkConstraints((Constraint)listIterator.next());
            }
            this.constraintMap.put(constraint.toString(), constraint);
        } else {
            this.checkConstraint(constraint);
            this.constraintMap.put(constraint.toString(), constraint);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkConstraint(Constraint constraint) {
        if (this.constraintMap.get(constraint.toString()) != null) {
            throw new IllegalArgumentException("Duplicate constraint.  The same constraint may only be applied to the same parameter once.");
        }
        if (constraint.getClass() == (class$com$novell$nds$dirxml$driver$xds$RangeConstraint == null ? (class$com$novell$nds$dirxml$driver$xds$RangeConstraint = Parameter.class$("com.novell.nds.dirxml.driver.xds.RangeConstraint")) : class$com$novell$nds$dirxml$driver$xds$RangeConstraint)) {
            if (DataType.IsRangeType(this.type)) return;
            throw new IllegalArgumentException("Range constraints can only be applied to types 'int', 'long', and 'char'.");
        }
        if (constraint.getClass() == (class$com$novell$nds$dirxml$driver$xds$EnumConstraint == null ? (class$com$novell$nds$dirxml$driver$xds$EnumConstraint = Parameter.class$("com.novell.nds.dirxml.driver.xds.EnumConstraint")) : class$com$novell$nds$dirxml$driver$xds$EnumConstraint)) {
            if (DataType.IsEnumerativeType(this.type)) return;
            throw new IllegalArgumentException("Cannot apply enumerative constraint to type 'boolean'.");
        }
        if (constraint.getClass() != (class$com$novell$nds$dirxml$driver$xds$BooleanConstraint == null ? (class$com$novell$nds$dirxml$driver$xds$BooleanConstraint = Parameter.class$("com.novell.nds.dirxml.driver.xds.BooleanConstraint")) : class$com$novell$nds$dirxml$driver$xds$BooleanConstraint)) return;
        if (!DataType.IsBooleanType(this.type)) throw new IllegalArgumentException("Boolean constraints can only be applied to type 'boolean'.");
        if (this.bool != null) throw new IllegalArgumentException("An parameter can have at most one boolean constraint.");
        this.bool = (BooleanConstraint)constraint;
    }

    public void add(Constraint constraint) {
        if (this.constant) {
            throw new IllegalStateException("Parameter is read-only.");
        }
        Lib.CheckParam(constraint, "someConstraint");
        this.checkConstraint(constraint);
        if (constraint.isRequired()) {
            this.setRequired();
        }
        constraint.setConstant();
        this.constraints.add(constraint);
    }

    private void setRequired() {
        this.required = true;
    }

    private void setDefault(String string) {
        if (string == null) {
            this.value = null;
        } else {
            this.value = this.applyTypeConstraints(string);
            if (this.value == null) {
                throw new IllegalArgumentException("Type mismatch.  Default value '" + string + "' of parameter '" + this.description + "' is not " + this.type.toClause());
            }
        }
    }

    void setType(DataType dataType) {
        this.type = dataType;
    }

    public ParamElement paramElement() {
        return this.param;
    }

    DataType getDataType() {
        return this.type;
    }

    public String tagName() {
        return this.tagName;
    }

    void setDescription(String string) {
        Lib.CheckParam(string, "someDescription");
        this.description = string;
    }

    String getDescription() {
        return this.description;
    }

    void setParamElement(ParamElement paramElement) {
        this.param = paramElement;
    }

    public void overrideValue(String string) {
        this.setDefault(string);
    }

    void setValue(String string) throws XDSParameterException {
        this.constant = true;
        if (string != null) {
            Object object = this.applyTypeConstraints(string);
            if (object == null) {
                String string2 = "Type mismatch.  Value '" + string + "' of parameter '" + this.description + "' is not " + this.type.toClause() + ".";
                if (this.type == DataType.INT) {
                    string2 = string2 + "  Legal values are " + IntConstraint.INT.toString() + ".";
                } else if (this.type == DataType.LONG) {
                    string2 = string2 + "  Legal values are " + LongConstraint.LONG.toString() + ".";
                } else if (this.type == DataType.BOOLEAN) {
                    string2 = string2 + "  Legal values are " + BooleanConstraint.BOOLEAN.toString() + ".";
                }
                throw new XDSParameterException(string2, this);
            }
            this.value = object;
        }
        this.applyOtherConstraints(string);
    }

    private void applyOtherConstraints(String string) throws XDSParameterException {
        if (!this.constraints.isEmpty()) {
            boolean bl = true;
            ListIterator listIterator = this.constraints.listIterator();
            while (listIterator.hasNext()) {
                Constraint constraint = (Constraint)listIterator.next();
                if (constraint.isValid(this, string)) continue;
                bl = false;
                break;
            }
            if (!bl) {
                this.throwParameterException(string);
            }
        }
    }

    private void throwParameterException(String string) throws XDSParameterException {
        boolean bl;
        int n = this.constraints.size();
        StringBuffer stringBuffer = new StringBuffer(32 * n);
        stringBuffer.append("Parameter '" + this.description);
        stringBuffer.append("' has illegal value '" + string + "'.");
        stringBuffer.append("  Legal values are ");
        boolean bl2 = bl = n > 1 || n == 1 && ((Constraint)this.constraints.get(0)).isContainer();
        if (bl) {
            stringBuffer.append("[");
        }
        int n2 = 1;
        ListIterator listIterator = this.constraints.listIterator();
        while (listIterator.hasNext()) {
            Constraint constraint = (Constraint)listIterator.next();
            stringBuffer.append(constraint.toString());
            if (n2 < n) {
                stringBuffer.append(" " + OP.toString() + " ");
            }
            ++n2;
        }
        if (bl) {
            stringBuffer.append("]");
        }
        stringBuffer.append(".");
        throw new XDSParameterException(stringBuffer.toString(), this);
    }

    private Object applyTypeConstraints(String string) {
        Object object;
        if (this.type == DataType.STRING || this.type == DataType.ANY) {
            object = string;
        } else if (this.type == DataType.CHAR) {
            object = CharConstraint.CHAR.parse(string);
        } else if (this.type == DataType.INT) {
            object = IntConstraint.INT.parse(string);
        } else if (this.type == DataType.LONG) {
            object = LongConstraint.LONG.parse(string);
        } else if (this.type == DataType.BOOLEAN) {
            object = BooleanConstraint.BOOLEAN.parse(this, string);
        } else {
            throw new RuntimeException("Broken IF-ELSEIF-ELSE statement.");
        }
        return object;
    }

    public Character toCharacter() {
        try {
            return (Character)this.value;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter value to type '" + DataType.CHAR.toString() + "'.  Parameter has data " + "type '" + this.type.toString() + "'.");
        }
    }

    public Integer toInteger() {
        try {
            return (Integer)this.value;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter value to type '" + DataType.INT.toString() + "'.  Parameter has data " + "type '" + this.type.toString() + "'.");
        }
    }

    public Long toLong() {
        try {
            return (Long)this.value;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter value to type '" + DataType.LONG.toString() + "'.  Parameter has data " + "type '" + this.type.toString() + "'.");
        }
    }

    public Boolean toBoolean() {
        try {
            return (Boolean)this.value;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Cannot convert parameter value to type '" + DataType.BOOLEAN.toString() + "'.  Parameter has data " + "type '" + this.type.toString() + "'.");
        }
    }

    public String toString() {
        return this.value == null ? null : this.value.toString();
    }

    boolean isRequired() {
        return this.required;
    }

    public int compareTo(Object object) {
        Lib.CheckParam(object, "someParam");
        Parameter parameter = (Parameter)object;
        String string = parameter.tagName();
        if (this.tagName.compareTo(string) < 0) {
            return -1;
        }
        if (this.tagName.compareTo(string) > 0) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

