/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.CharComparator;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.EqualityOp;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.LongComparator;
import com.novell.nds.dirxml.driver.xds.Parameter;
import java.util.Comparator;

public class RangeConstraint
extends Constraint {
    public static final RangeConstraint POSITIVE;
    public static final RangeConstraint NON_NEGATIVE;
    public static final RangeConstraint NEGATIVE;
    private static final Comparator COMP_CHAR;
    private static final Comparator COMP_LONG;
    private static final String RANGE_SYMBOL;
    private static final boolean DEFAULT_NOT;
    private static final boolean DEFAULT_EMPTY;
    private Comparator comparator;
    private boolean same;
    private String first;
    private String last;
    private boolean empty;
    private EqualityOp op;

    private void init() {
        this.not = DEFAULT_NOT;
        this.empty = DEFAULT_EMPTY;
    }

    public RangeConstraint(char c, char c2) {
        this.init();
        this.same = c == c2;
        this.op = EqualityOp.NONE;
        this.comparator = COMP_CHAR;
        this.first = String.valueOf(c);
        this.last = String.valueOf(c2);
    }

    public RangeConstraint(long l, long l2) {
        this.init();
        this.same = l == l2;
        this.op = EqualityOp.NONE;
        this.comparator = COMP_LONG;
        this.first = String.valueOf(l);
        this.last = String.valueOf(l2);
    }

    private void setEmpty() {
        this.empty = true;
    }

    public RangeConstraint(long l, EqualityOp equalityOp) {
        Lib.CheckParam(equalityOp, "someOp");
        this.init();
        if (l == Long.MIN_VALUE && equalityOp == EqualityOp.LT || l == Long.MAX_VALUE && equalityOp == EqualityOp.GT) {
            this.setEmpty();
        }
        this.same = false;
        this.op = equalityOp;
        this.first = String.valueOf(l);
        this.comparator = COMP_LONG;
        this.last = null;
    }

    boolean isValid(Parameter parameter, String string) {
        if (string == null) {
            return true;
        }
        return this.empty ? false : this.compare(string);
    }

    public void setNOT() {
        this.checkConstant();
        this.not = true;
    }

    private boolean compare(String string) {
        boolean bl;
        int n = this.comparator.compare(string, this.first);
        if (this.op == EqualityOp.NONE) {
            bl = n != -1 && this.comparator.compare(string, this.last) != 1;
        } else {
            switch (n) {
                case -1: {
                    bl = EqualityOp.IsLessThan(this.op);
                    break;
                }
                case 1: {
                    bl = EqualityOp.IsGreaterThan(this.op);
                    break;
                }
                case 0: {
                    bl = EqualityOp.MayBeEqual(this.op);
                    break;
                }
                default: {
                    throw new RuntimeException("Broken SWITCH statement.");
                }
            }
        }
        return this.not ? !bl : bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getLegalValues() {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (this.empty) {
            return "";
        }
        if (this.op == EqualityOp.NONE) {
            if (this.same) {
                if (this.comparator == COMP_CHAR) {
                    stringBuffer.append("'" + this.first + "'");
                    return stringBuffer.toString();
                } else {
                    if (this.comparator != COMP_LONG) throw new RuntimeException("Broken IF-ELSEIF-ELSE statement.");
                    stringBuffer.append(this.first);
                }
                return stringBuffer.toString();
            } else if (this.comparator == COMP_CHAR) {
                stringBuffer.append("'" + this.first + "' ");
                stringBuffer.append(RANGE_SYMBOL);
                stringBuffer.append("'" + this.last + "'");
                return stringBuffer.toString();
            } else {
                if (this.comparator != COMP_LONG) throw new RuntimeException("Broken IF-ELSEIF-ELSE statement.");
                stringBuffer.append(this.first);
                stringBuffer.append(RANGE_SYMBOL);
                stringBuffer.append(this.last);
            }
            return stringBuffer.toString();
        } else if (this.op == EqualityOp.GTE) {
            stringBuffer.append(this.first + RANGE_SYMBOL + "n");
            return stringBuffer.toString();
        } else if (this.op == EqualityOp.LTE) {
            stringBuffer.append("n" + RANGE_SYMBOL + this.first);
            return stringBuffer.toString();
        } else if (this.op == EqualityOp.GT) {
            stringBuffer.append(String.valueOf(Long.parseLong(this.first) + 1L));
            stringBuffer.append(RANGE_SYMBOL + "n");
            return stringBuffer.toString();
        } else {
            if (this.op != EqualityOp.LT) return stringBuffer.toString();
            stringBuffer.append("n" + RANGE_SYMBOL);
            stringBuffer.append(String.valueOf(Long.parseLong(this.first) - 1L));
        }
        return stringBuffer.toString();
    }

    static {
        DEFAULT_EMPTY = false;
        DEFAULT_NOT = false;
        RANGE_SYMBOL = "...";
        COMP_CHAR = new CharComparator();
        COMP_LONG = new LongComparator();
        RangeConstraint rangeConstraint = new RangeConstraint(0L, EqualityOp.GT);
        rangeConstraint.setConstant();
        POSITIVE = rangeConstraint;
        rangeConstraint = new RangeConstraint(0L, EqualityOp.LT);
        rangeConstraint.setConstant();
        NEGATIVE = rangeConstraint;
        rangeConstraint = new RangeConstraint(0L, EqualityOp.GTE);
        rangeConstraint.setConstant();
        NON_NEGATIVE = rangeConstraint;
    }
}

