/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DTD;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds._Boolean;
import org.w3c.dom.Element;

public class XDSAttrDefElement
extends ElementImpl {
    private static final int INDEX_CASE_SENSITIVE = 0;
    private static final int INDEX_MULTI_VALUED = 1;
    private static final int INDEX_NAMING = 2;
    private static final int INDEX_READ_ONLY = 3;
    private static final int INDEX_REQUIRED = 4;
    private static final String[] BOOL_ATTR_NAMES = new String[]{"case-sensitive", "multi-valued", "naming", "read-only", "required"};
    private static final _Boolean[] BOOL_ATTR_DEFAULTS = new _Boolean[]{_Boolean.FALSE, _Boolean.TRUE, _Boolean.FALSE, _Boolean.FALSE, _Boolean.FALSE};
    private String attrName;
    private _Boolean[] booleans;
    private ValueType type;
    private String typeStr;

    private void readInit() {
        this.booleans = new _Boolean[BOOL_ATTR_NAMES.length];
    }

    private void writeInit() {
        this.booleans = BOOL_ATTR_DEFAULTS;
    }

    XDSAttrDefElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.readInit();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void parseAttributes() {
        this.attrName = this.attributeValueGet("attr-name");
        this.typeStr = this.attributeValueGet("type");
        this.type = ValueType.Lookup(this.typeStr);
        int n = 0;
        while (n < BOOL_ATTR_NAMES.length) {
            this.booleans[n] = Lib.ToBoolean(this.attributeValueGet(BOOL_ATTR_NAMES[n]), BOOL_ATTR_DEFAULTS[n]);
            ++n;
        }
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.attrName == null) {
                throw new XDSParseException(Errors.NoAttributeValue("attr-name"));
            }
            if (this.type == null) {
                throw new XDSParseException(Errors.BadValueType(this.typeStr));
            }
            int n = 0;
            while (n < BOOL_ATTR_NAMES.length) {
                if (this.booleans[n].equals(_Boolean.ILLEGAL)) {
                    throw new XDSParseException(Errors.BadBooleanType(this.booleans[n].toString()));
                }
                ++n;
            }
        }
    }

    String getAttrName() {
        return this.attrName;
    }

    String getASN1ID() {
        return Lib.GetAttributeValue(this, "asn1id");
    }

    boolean getCaseSensitive() {
        return this.booleans[0].toPrimitive();
    }

    boolean getMultiValued() {
        return this.booleans[1].toPrimitive();
    }

    boolean getNaming() {
        return this.booleans[2].toPrimitive();
    }

    boolean getReadOnly() {
        return this.booleans[3].toPrimitive();
    }

    boolean getRequired() {
        return this.booleans[4].toPrimitive();
    }

    ValueType getType() {
        return this.type;
    }

    XDSAttrDefElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "attr-def");
        this.writeInit();
    }

    public void setAttrName(String string) {
        this.attributeValueSet("attr-name", string);
    }

    public void setASN1ID(String string) {
        this.attributeValueSet("asn1id", string);
    }

    public void setCaseSensitive(boolean bl) {
        this.attributeValueSet("case-sensitive", DTD.GetStringValue(bl));
    }

    public void setMultiValued(boolean bl) {
        this.attributeValueSet("multi-valued", DTD.GetStringValue(bl));
    }

    public void setNaming(boolean bl) {
        this.attributeValueSet("naming", DTD.GetStringValue(bl));
    }

    public void setReadOnly(boolean bl) {
        this.attributeValueSet("read-only", DTD.GetStringValue(bl));
    }

    public void setRequired(boolean bl) {
        this.attributeValueSet("required", DTD.GetStringValue(bl));
    }

    public void setType(ValueType valueType) {
        this.setAttributeValue("type", valueType);
    }
}

