/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DTD;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAttrDefElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds._Boolean;
import java.util.List;
import org.w3c.dom.Element;

public class XDSClassDefElement
extends ElementImpl {
    private static final _Boolean DEFAULT_CONTAINER = _Boolean.FALSE;
    private _Boolean container;
    private String className;

    private void init() {
        this.container = DEFAULT_CONTAINER;
        this.className = null;
    }

    XDSClassDefElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void parseAttributes() throws XDSParseException {
        this.className = this.attributeValueGet("class-name");
        this.container = Lib.ToBoolean(this.attributeValueGet("container"), DEFAULT_CONTAINER);
    }

    private void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.className == null) {
                throw new XDSParseException(Errors.NoAttributeValue("class-name"));
            }
            if (this.container.equals(_Boolean.ILLEGAL)) {
                throw new XDSParseException(Errors.BadBooleanType(this.container.toString()));
            }
        }
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        XDSAttrDefElement xDSAttrDefElement = null;
        if ("attr-def".compareTo(string) == 0) {
            xDSAttrDefElement = new XDSAttrDefElement(element, this.document);
        }
        return xDSAttrDefElement;
    }

    String getClassName() {
        return Lib.GetValue((ElementImpl)this, this.className);
    }

    boolean getContainer() {
        return Lib.GetValue((ElementImpl)this, this.container);
    }

    String getASN1ID() {
        return Lib.GetAttributeValue(this, "asn1id");
    }

    public List childElements() {
        return super.childElements();
    }

    XDSClassDefElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "class-def");
    }

    public void setClassName(String string) {
        this.attributeValueSet("class-name", string);
    }

    public void setASN1ID(String string) {
        this.attributeValueSet("asn1id", string);
    }

    public void setContainer(boolean bl) {
        this.attributeValueSet("container", DTD.GetStringValue(bl));
    }

    public XDSAttrDefElement appendAttrDefElement() {
        return new XDSAttrDefElement(this.document, this.element);
    }
}

