/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.NDSVersion;
import com.novell.nds.dirxml.driver.xds.ReadableDocument;
import com.novell.nds.dirxml.driver.xds.StateDocument;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.ValidationLevel;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAddElement;
import com.novell.nds.dirxml.driver.xds.XDSCheckObjectPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSDeleteElement;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSMoveElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSRenameElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XDSCommandDocument
extends DocumentImpl
implements ReadableDocument,
WriteableDocument,
StatusDocument,
StateDocument {
    private XDSInitParamsElement[] initParams;
    private XDSQueryElement identity;

    private void readInit() {
        this.initParams = null;
        this.commandContainer = true;
        this.identity = null;
    }

    private void writeInit() {
        this.initParams = new XDSInitParamsElement[1];
        this.initParams[0] = null;
        this.identity = null;
    }

    public XDSCommandDocument(XmlDocument xmlDocument) throws XDSParseException {
        super(xmlDocument, "input", 0, DocumentImpl.DEFAULT_READ_VALIDATION_LEVEL);
        this.readInit();
        this.parseChildNodes();
    }

    public DTDVersion getDTDVersion() {
        return Lib.ReadableDocument_dtdVersion(this);
    }

    public XDSSourceElement extractSourceElement() {
        return this.source;
    }

    public List childElements() {
        return super.childElements();
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if (this.context == 0) {
            if ("add".compareTo(string) == 0) {
                elementImpl = new XDSAddElement(element, this);
            } else if ("modify".compareTo(string) == 0) {
                elementImpl = new XDSModifyElement(element, this);
            } else if ("delete".compareTo(string) == 0) {
                elementImpl = new XDSDeleteElement(element, this);
            } else if ("query".compareTo(string) == 0) {
                XDSQueryElement xDSQueryElement = new XDSQueryElement(element, this);
                elementImpl = xDSQueryElement;
                if (this.identity == null && xDSQueryElement.isIdentity()) {
                    this.identity = xDSQueryElement;
                }
            } else if ("move".compareTo(string) == 0) {
                elementImpl = new XDSMoveElement(element, this);
            } else if ("rename".compareTo(string) == 0) {
                elementImpl = new XDSRenameElement(element, this);
            }
            if (elementImpl == null && this.GTE(DTDVersion.V1_1) && "modify-password".compareTo(string) == 0) {
                elementImpl = new XDSModifyPasswordElement(element, this);
            }
            if (elementImpl == null && this.GTE(DTDVersion.V2_0) && "check-object-password".compareTo(string) == 0) {
                elementImpl = new XDSCheckObjectPasswordElement(element, this);
            }
        } else {
            if ("add".compareTo(string) == 0) {
                elementImpl = new XDSAddElement(element, this);
            } else if ("delete".compareTo(string) == 0) {
                elementImpl = new XDSDeleteElement(element, this);
            } else if ("modify".compareTo(string) == 0) {
                elementImpl = new XDSModifyElement(element, this);
            } else if ("move".compareTo(string) == 0) {
                elementImpl = new XDSMoveElement(element, this);
            } else if ("rename".compareTo(string) == 0) {
                elementImpl = new XDSRenameElement(element, this);
            } else if ("status".compareTo(string) == 0) {
                elementImpl = new XDSStatusElement(element, this);
            } else if ("init-params".compareTo(string) == 0) {
                elementImpl = new XDSInitParamsElement(element, this);
            } else if ("remove-association".compareTo(string) == 0) {
                elementImpl = new XDSRemoveAssociationElement(element, this);
            } else if ("modify-association".compareTo(string) == 0) {
                elementImpl = new XDSModifyAssociationElement(element, this);
            }
            if (elementImpl == null && this.GTE(DTDVersion.V1_1) && "modify-password".compareTo(string) == 0) {
                elementImpl = new XDSModifyPasswordElement(element, this);
            }
        }
        return elementImpl;
    }

    public XDSCommandDocument() {
        super("input", 1, NDSVersion.CURRENT, DTDVersion.CURRENT);
        this.writeInit();
    }

    public XDSCommandDocument(DTDVersion dTDVersion) {
        super("input", 1, NDSVersion.CURRENT, dTDVersion);
        this.writeInit();
    }

    public XDSAddElement appendAddElement() {
        return new XDSAddElement(this, this.ioElement);
    }

    public XDSModifyElement appendModifyElement() {
        return new XDSModifyElement(this, this.ioElement);
    }

    public XDSRenameElement appendRenameElement() {
        return new XDSRenameElement(this, this.ioElement);
    }

    public XDSDeleteElement appendDeleteElement() {
        return new XDSDeleteElement(this, this.ioElement);
    }

    public XDSMoveElement appendMoveElement() {
        return new XDSMoveElement(this, this.ioElement);
    }

    private XDSCommandDocument(Document document, ValidationLevel validationLevel) throws XDSParseException {
        super(document, "input", 1, validationLevel);
        this.readInit();
        this.parseChildNodes();
    }

    public void validate() throws XDSParseException {
        new XDSCommandDocument(this.document, ValidationLevel.STRICT);
    }

    public XmlDocument toXML() {
        return Lib.WriteableDocument_toXML(this);
    }

    public XDSModifyAssociationElement appendModifyAssociationElement() {
        return Lib.WriteableDocument_appendModifyAssociationElement(this);
    }

    public XDSModifyPasswordElement appendModifyPasswordElement() {
        return new XDSModifyPasswordElement(this, this.ioElement);
    }

    public XDSStatusElement heartBeatAppend() {
        return Lib.StatusDocument_appendHeartbeat(this);
    }

    public XDSSourceElement appendSourceElement() {
        this.source = Lib.WriteableDocument_appendSourceElement(this, this.source);
        return this.source;
    }

    public XDSStatusElement appendStatusElement() {
        return new XDSStatusElement(this, this.ioElement);
    }

    public XDSInitParamsElement appendInitParamsElement() {
        return Lib.StateDocument_appendInitParamsElement(this, this.initParams);
    }

    public void empty() {
        Lib.WriteableDocument_setEmpty(this);
    }

    public boolean containsIdentityQuery() {
        return this.identity != null;
    }

    public XDSQueryElement identityQuery() {
        return this.identity;
    }
}

