/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.DriverFilter;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.ReadableDocument;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class XDSInitDocument
extends DocumentImpl
implements ReadableDocument {
    private XDSInitParamsElement initParams;

    private void init() {
        this.initParams = null;
    }

    public XDSInitDocument(XmlDocument xmlDocument) throws XDSParseException {
        super(xmlDocument, "input", 0, DocumentImpl.DEFAULT_READ_VALIDATION_LEVEL);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.validate && this.initParams == null) {
            throw new XDSParseException(Errors.NoElement("init-params"));
        }
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        XDSInitParamsElement xDSInitParamsElement = null;
        if ("init-params".compareTo(string) == 0) {
            xDSInitParamsElement = new XDSInitParamsElement(element, this);
            if (this.initParams == null) {
                this.initParams = xDSInitParamsElement;
            }
        }
        return xDSInitParamsElement;
    }

    public XDSSourceElement extractSourceElement() {
        return Lib.ReadableDocument_sourceElement(this);
    }

    public DriverFilter driverFilter() {
        if (this.initParams == null) {
            return new DriverFilter();
        }
        return this.initParams.driverFilter();
    }

    public String srcDN() {
        return this.initParams == null ? null : this.initParams.getSrcDN();
    }

    public String rdn() {
        return this.initParams == null ? null : this.initParams.rdn();
    }

    public String treeName() {
        return this.initParams == null ? null : this.initParams.treeName();
    }

    public String containerDN() {
        return this.initParams == null ? null : this.initParams.containerDN();
    }

    public void parameters(Map map) throws XDSParameterException {
        if (this.initParams == null) {
            XDSParameterException xDSParameterException = null;
            XDSParameterException xDSParameterException2 = null;
            XDSParameterException xDSParameterException3 = null;
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                if (!parameter.isRequired()) continue;
                xDSParameterException3 = new XDSParameterException("Missing required parameter element '" + parameter.tagName() + "'.");
                if (xDSParameterException2 == null) {
                    xDSParameterException = xDSParameterException3;
                    xDSParameterException2 = xDSParameterException3;
                    continue;
                }
                xDSParameterException2.setNext(xDSParameterException3);
                xDSParameterException2 = xDSParameterException3;
            }
            if (xDSParameterException != null) {
                throw xDSParameterException;
            }
        } else if (this.initParams.uniqueParams()) {
            Lib.ExtractParams(this.initParams.paramMap(), map);
        } else {
            throw new XDSParameterException("Initialization document contains one or more parameters with the same tag name.  Parameter tag names must be unique.");
        }
    }

    public DTDVersion getDTDVersion() {
        return Lib.ReadableDocument_dtdVersion(this);
    }

    public XDSInitParamsElement extractInitParamsElement() {
        return this.initParams;
    }

    public List childElements() {
        return super.childElements();
    }
}

