/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.PasswordElementParent;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSOldPasswordElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSPasswordElement;
import java.util.List;
import org.w3c.dom.Element;

public class XDSModifyPasswordElement
extends ElementImpl
implements CommandElement,
PasswordElementParent,
AssociationElementParent {
    private XDSAssociationElement association;
    private int noOfAssociations;
    private XDSOldPasswordElement oldPassword;
    private int noOfOldPasswords;
    private XDSPasswordElement password;
    private int noOfPasswords;

    private void init() {
        this.password = null;
        this.oldPassword = null;
        this.association = null;
        this.noOfAssociations = 0;
        this.noOfOldPasswords = 0;
        this.noOfPasswords = 0;
    }

    XDSModifyPasswordElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseChildNodes();
        this.validate();
    }

    protected void validate() throws XDSParseException {
        if (this.document.validate) {
            if (this.noOfPasswords > 1) {
                throw new XDSParseException(Errors.DuplicateElement("password"));
            }
            if (this.password == null) {
                throw new XDSParseException(Errors.NoElement("password"));
            }
            if (this.noOfOldPasswords > 1) {
                throw new XDSParseException(Errors.DuplicateElement("old-password"));
            }
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, false);
            if (this.document.isStrict() && this.password.position() != this.children().size()) {
                throw new XDSParseException(Errors.MisplacedElement(this.tagName(), "password", this.children().size()));
            }
        }
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String extractOldPasswordText() {
        return Lib.GetText(this, this.oldPassword);
    }

    public String extractPasswordText() {
        return Lib.PasswordElementParent_passwordText(this, this.password);
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    public XDSPasswordElement extractPasswordElement() {
        return this.password;
    }

    public XDSOldPasswordElement extractOldPasswordElement() {
        return this.oldPassword;
    }

    public String getClassName() {
        return Lib.GetAttributeValue(this, "class-name");
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getDestDN() {
        return Lib.GetAttributeValue(this, "dest-dn");
    }

    private void setPassword(XDSPasswordElement xDSPasswordElement) {
        if (this.password == null) {
            this.password = xDSPasswordElement;
        }
        ++this.noOfPasswords;
    }

    private void setOldPassword(XDSOldPasswordElement xDSOldPasswordElement) {
        if (this.oldPassword == null) {
            this.oldPassword = xDSOldPasswordElement;
        }
        ++this.noOfOldPasswords;
    }

    private void setAssociation(XDSAssociationElement xDSAssociationElement) {
        if (this.association == null) {
            this.association = xDSAssociationElement;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("password".compareTo(string) == 0) {
            elementImpl = new XDSPasswordElement(element, this.document);
            this.setPassword((XDSPasswordElement)elementImpl);
        } else if ("old-password".compareTo(string) == 0) {
            elementImpl = new XDSOldPasswordElement(element, this.document);
            this.setOldPassword((XDSOldPasswordElement)elementImpl);
        } else if ("association".compareTo(string) == 0) {
            elementImpl = new XDSAssociationElement(element, this.document);
            this.setAssociation((XDSAssociationElement)elementImpl);
        }
        return elementImpl;
    }

    public List childElements() {
        return super.childElements();
    }

    XDSModifyPasswordElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "modify-password");
    }

    public void setEventID(String string) {
        Lib.CommandElement_setEventID(this, string);
    }

    public void setClassName(String string) {
        this.attributeValueSet("class-name", string);
    }

    public void setSrcDN(String string) {
        this.attributeValueSet("src-dn", string);
    }

    public void setDestDN(String string) {
        this.attributeValueSet("dest-dn", string);
    }

    public void setDestEntryID(String string) {
        this.attributeValueSet("dest-entry-id", string);
    }

    public XDSAssociationElement appendAssociationElement(String string) {
        return Lib.AssociationElementParent_appendAssociationElement(this, string);
    }

    public XDSPasswordElement appendPasswordElement(String string) {
        this.password = new XDSPasswordElement(this.document, this.element);
        this.password.appendText(string);
        return this.password;
    }

    public XDSOldPasswordElement appendOldPasswordElement(String string) {
        return new XDSOldPasswordElement(this.document, this.element);
    }
}

