/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.DTDVersion;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.NDSVersion;
import com.novell.nds.dirxml.driver.xds.ReadableDocument;
import com.novell.nds.dirxml.driver.xds.ValidationLevel;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSInitParamsElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSSourceElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XDSQueryDocument
extends DocumentImpl
implements ReadableDocument,
WriteableDocument {
    private XDSInitParamsElement[] initParams;
    private List queries;

    private void readInit() {
        this.initParams = null;
        this.queries = Collections.EMPTY_LIST;
        this.commandContainer = true;
    }

    private void writeInit() {
        this.queries = null;
        this.initParams = new XDSInitParamsElement[1];
        this.initParams[0] = null;
    }

    public XDSQueryDocument(XmlDocument xmlDocument) throws XDSParseException {
        super(xmlDocument, "input", 0, DocumentImpl.DEFAULT_READ_VALIDATION_LEVEL);
        this.readInit();
        this.parseChildNodes();
    }

    public XDSSourceElement extractSourceElement() {
        return this.source;
    }

    public List extractQueryElements() {
        if (this.isStrict()) {
            return this.childElements();
        }
        return this.queries;
    }

    public DTDVersion getDTDVersion() {
        return Lib.ReadableDocument_dtdVersion(this);
    }

    public List childElements() {
        return super.childElements();
    }

    private void addQuery(XDSQueryElement xDSQueryElement, int n) {
        if (!this.isStrict()) {
            if (this.queries == Collections.EMPTY_LIST) {
                this.queries = new ArrayList(n);
            }
            this.queries.add(xDSQueryElement);
        }
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        XDSQueryElement xDSQueryElement = null;
        if ("query".compareTo(string) == 0) {
            xDSQueryElement = new XDSQueryElement(element, this);
            this.addQuery(xDSQueryElement, n2);
        }
        return xDSQueryElement;
    }

    public XDSQueryDocument() {
        super("input", 1, NDSVersion.CURRENT, DTDVersion.CURRENT);
        this.writeInit();
    }

    public XDSQueryDocument(DTDVersion dTDVersion) {
        super("input", 1, NDSVersion.CURRENT, dTDVersion);
        this.writeInit();
    }

    public XDSQueryElement appendQueryElement() {
        return new XDSQueryElement(this, this.ioElement);
    }

    private XDSQueryDocument(Document document, ValidationLevel validationLevel) throws XDSParseException {
        super(document, "input", 1, validationLevel);
        this.readInit();
        this.parseChildNodes();
    }

    public XDSSourceElement appendSourceElement() {
        this.source = Lib.WriteableDocument_appendSourceElement(this, this.source);
        return this.source;
    }

    public void validate() throws XDSParseException {
        new XDSQueryDocument(this.document, ValidationLevel.STRICT);
    }

    public XmlDocument toXML() {
        return Lib.WriteableDocument_toXML(this);
    }

    public void empty() {
        Lib.WriteableDocument_setEmpty(this);
    }
}

