/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.ReadAttrType;
import com.novell.nds.dirxml.driver.xds.SomeAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import org.w3c.dom.Element;

public class XDSReadAttrElement
extends ElementImpl
implements SomeAttrElement {
    private String attrName;
    private ReadAttrType type;
    private String typeString;

    private void init() {
        this.attrName = null;
        this.type = null;
        this.typeString = null;
    }

    XDSReadAttrElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.validate();
    }

    private void validate() throws XDSParseException {
        if (this.document.validate && this.type == null) {
            if (this.typeString == null) {
                this.throwMissingAttributeException("type");
            } else {
                throw new XDSParseException(Errors.BadAttributeValue("type", this.typeString));
            }
        }
    }

    private void parseAttributes() {
        this.attrName = this.attributeValueGet("attr-name");
        this.typeString = this.attributeValueGet("type");
        this.type = ReadAttrType.Lookup(this.typeString);
    }

    public String getAttrName() {
        return Lib.SomeAttrElement_getAttrName(this, this.attrName);
    }

    public boolean isNameless() {
        return this.attrName == null;
    }

    boolean _isNameless() {
        return this.attrName == null;
    }

    public ReadAttrType getType() {
        if (this.type == null) {
            return ReadAttrType.DEFAULT;
        }
        return this.type;
    }

    public boolean hasXMLType() {
        return this.type == ReadAttrType.XML;
    }

    public boolean hasDefaultType() {
        return this.type == ReadAttrType.DEFAULT;
    }

    XDSReadAttrElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "read-attr");
    }

    public void setAttrName(String string) {
        Lib.SomeAttrElement_setAttrName(this, string);
    }

    public void setType(ReadAttrType readAttrType) {
        this.setAttributeValue("type", readAttrType);
    }
}

