/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.AssociationElementParent;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.DTD;
import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.XDSAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSNewNameElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.nds.dirxml.driver.xds._Boolean;
import java.util.List;
import org.w3c.dom.Element;

public class XDSRenameElement
extends ElementImpl
implements CommandElement,
AssociationElementParent {
    private static final _Boolean DEFAULT_REMOVE_OLD_NAME = _Boolean.TRUE;
    private XDSAssociationElement association;
    private XDSNewNameElement newName;
    private _Boolean removeOldName;
    private int noOfAssociations;
    private int noOfNewNames;

    private void init() {
        this.removeOldName = DEFAULT_REMOVE_OLD_NAME;
        this.association = null;
        this.newName = null;
        this.noOfAssociations = 0;
        this.noOfNewNames = 0;
    }

    XDSRenameElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    private void parseAttributes() {
        this.removeOldName = Lib.ToBoolean(this.attributeValueGet("remove-old-name"), DEFAULT_REMOVE_OLD_NAME);
    }

    protected void validate() throws XDSParseException {
        if (this.document.validate) {
            Lib.AssociationElementParent_validate(this, this.association, this.noOfAssociations, true);
            if (this.newName == null) {
                throw new XDSParseException(Errors.NoElement("new-name"));
            }
            if (this.noOfNewNames > 1) {
                throw new XDSParseException(Errors.DuplicateElement("new-name"));
            }
            if (this.removeOldName.equals(_Boolean.ILLEGAL)) {
                throw new XDSParseException(Errors.BadBooleanType(this.removeOldName.toString()));
            }
        }
    }

    public List childElements() {
        return super.childElements();
    }

    public String getClassName() {
        return Lib.GetAttributeValue(this, "class-name");
    }

    public String getSrcDN() {
        return Lib.CommandElement_getSrcDN(this);
    }

    public String getQualifiedSrcDN() {
        return Lib.CommandElement_getQualifiedSrcDN(this);
    }

    public String getQualifiedOldSrcDN() {
        return Lib.GetAttributeValue(this, "qualified-old-src-dn");
    }

    public String getSrcEntryID() {
        return Lib.CommandElement_getSrcEntryID(this);
    }

    public String getEventID() {
        return Lib.CommandElement_getEventID(this);
    }

    public String getOldSrcDN() {
        return Lib.GetAttributeValue(this, "old-src-dn");
    }

    public boolean getRemoveOldName() {
        return Lib.GetValue((ElementImpl)this, this.removeOldName);
    }

    public XDSNewNameElement extractNewNameElement() {
        return this.newName;
    }

    public String extractNewNameText() {
        return Lib.GetText(this, this.newName);
    }

    public XDSAssociationElement extractAssociationElement() {
        return Lib.AssociationElementParent_associationElement(this, this.association);
    }

    public String extractAssociationText() {
        return Lib.AssociationElementParent_associationText(this, this.association);
    }

    private void setNewName(XDSNewNameElement xDSNewNameElement) {
        if (this.newName == null) {
            this.newName = xDSNewNameElement;
        }
        ++this.noOfNewNames;
    }

    private void setAssociation(XDSAssociationElement xDSAssociationElement) {
        if (this.association == null) {
            this.association = xDSAssociationElement;
        }
        ++this.noOfAssociations;
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        ElementImpl elementImpl = null;
        if ("new-name".equals(string)) {
            elementImpl = new XDSNewNameElement(element, this.document);
            this.setNewName((XDSNewNameElement)elementImpl);
        } else if ("association".compareTo(string) == 0) {
            elementImpl = new XDSAssociationElement(element, this.document);
            this.setAssociation((XDSAssociationElement)elementImpl);
        }
        return elementImpl;
    }

    XDSRenameElement(DocumentImpl documentImpl, Element element) {
        super(documentImpl, element, "rename");
    }

    public XDSNewNameElement appendNewNameElement(String string) {
        XDSNewNameElement xDSNewNameElement = new XDSNewNameElement(this.document, this.element);
        xDSNewNameElement.appendText(string);
        return xDSNewNameElement;
    }

    public void setSrcDN(String string) {
        this.attributeValueSet("src-dn", string);
    }

    public void setRemoveOldName(boolean bl) {
        this.attributeValueSet("remove-old-name", DTD.GetStringValue(bl));
    }

    public void setClassName(String string) {
        this.attributeValueSet("class-name", string);
    }

    public void setEventID(String string) {
        this.attributeValueSet("event-id", string);
    }

    public void setOldSrcDN(String string) {
        this.attributeValueSet("old-src-dn", string);
    }

    public void setDestDN(String string) {
        this.attributeValueSet("dest-dn", string);
    }

    public void setDestEntryID(String string) {
        this.attributeValueSet("dest-entry-id", string);
    }

    public XDSAssociationElement appendAssociationElement(String string) {
        return Lib.AssociationElementParent_appendAssociationElement(this, string);
    }
}

