/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds;

import com.novell.nds.dirxml.driver.xds.DocumentImpl;
import com.novell.nds.dirxml.driver.xds.ElementImpl;
import com.novell.nds.dirxml.driver.xds.Errors;
import com.novell.nds.dirxml.driver.xds.Lib;
import com.novell.nds.dirxml.driver.xds.TextParent;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.XDSComponentElement;
import com.novell.nds.dirxml.driver.xds.XDSParseException;
import com.novell.xml.util.Base64Codec;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XDSValueElement
extends ElementImpl
implements TextParent {
    private String typeString;
    private ValueType valueType;
    private String text;
    private String associationRef;
    private int noOfComponents;

    private void init() {
        this.text = "";
        this.associationRef = null;
        this.typeString = null;
        this.valueType = null;
        this.noOfComponents = 0;
    }

    protected void passText(String string) throws XDSParseException {
        this.text = this.text + string;
    }

    XDSValueElement(Element element, DocumentImpl documentImpl) throws XDSParseException {
        super(element, documentImpl);
        this.init();
        this.parseAttributes();
        this.parseChildNodes();
        this.validate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validate() throws XDSParseException {
        if (!this.document.validate) return;
        if (this.valueType == null) {
            if (this.typeString != null) throw new XDSParseException(Errors.UnsupportedType(this.typeString));
            this.throwMissingAttributeException("type");
            return;
        } else {
            if (this.valueType == ValueType.DN) {
                if (this.associationRef != null || this.text != null) return;
                throw new XDSParseException(Errors.NoText("value"));
            }
            if (this.valueType == ValueType.STRUCTURED) {
                if (this.noOfComponents >= 1) return;
                throw new XDSParseException(Errors.NoElement("component"));
            }
            if (this.noOfComponents > 0) {
                throw new XDSParseException(Errors.ReqTypeStructured());
            }
            if (this.associationRef == null) return;
            throw new XDSParseException(Errors.ReqTypeDN());
        }
    }

    private void parseAttributes() {
        this.typeString = this.attributeValueGet("type");
        this.valueType = ValueType.Lookup(this.typeString);
        this.associationRef = this.attributeValueGet("association-ref");
    }

    public String getAssociationRef() {
        return Lib.GetValue((ElementImpl)this, this.associationRef);
    }

    public String extractText() {
        return Lib.TextParent_text(this, this.text);
    }

    public byte[] bytes() throws IOException {
        if (this.valueType != ValueType.OCTET || this.text == null) {
            return null;
        }
        return Base64Codec.decode((String)this.text);
    }

    public ValueType getType() {
        return this.valueType;
    }

    public List extractComponentElements() {
        return super.childElements();
    }

    protected ElementImpl parseChildElement(Element element, String string, int n, int n2) throws XDSParseException {
        XDSComponentElement xDSComponentElement = null;
        if ("component".compareTo(string) == 0) {
            xDSComponentElement = new XDSComponentElement(element, this.document);
            ++this.noOfComponents;
        }
        return xDSComponentElement;
    }

    boolean isEmpty() {
        return this.children() == Collections.EMPTY_LIST && this.text == "";
    }

    XDSValueElement(DocumentImpl documentImpl, Element element, ValueType valueType) {
        super(documentImpl, element, "value");
        if (valueType != null) {
            this.valueType = valueType;
            this.element.setAttribute("type", valueType.toString());
        }
    }

    public void setType(ValueType valueType) {
        this.setAttributeValue("type", valueType);
    }

    public void appendText(String string) {
        Lib.TextParent_appendText(this, string);
    }

    public void appendBytes(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return;
        }
        this.appendBase64EncodedText(Base64Codec.encode((byte[])byArray, (int)n, (int)n2));
    }

    public void appendBytes(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.appendBase64EncodedText(Base64Codec.encode((byte[])byArray));
    }

    private void appendBase64EncodedText(char[] cArray) {
        Text text = this.document.document.createTextNode(String.valueOf(cArray));
        this.element.appendChild(text);
    }

    public XDSComponentElement appendComponentElement() {
        return new XDSComponentElement(this.document, this.element);
    }

    public void setAssociationRef(String string) {
        this.attributeValueSet("association-ref", string);
    }
}

