/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.xds.util;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.XDSParameterException;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.util.Lib;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XDSUtil {
    private XDSUtil() {
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        return byteArrayOutputStream.toString();
    }

    public static long toMillis(int n) {
        return n * 1000;
    }

    public static XDSStatusElement appendStatus(StatusDocument statusDocument, StatusAttributes statusAttributes, String string) {
        XDSStatusElement xDSStatusElement = statusDocument.appendStatusElement();
        if (statusAttributes != null) {
            xDSStatusElement.setLevel(statusAttributes.getLevel());
            xDSStatusElement.setType(statusAttributes.getType());
            xDSStatusElement.setEventID(statusAttributes.getEventID());
        }
        xDSStatusElement.descriptionAppend(string);
        return xDSStatusElement;
    }

    private static XDSStatusElement appendStatus(StatusDocument statusDocument, StatusAttributes statusAttributes, XDSParameterException xDSParameterException, XmlDocument xmlDocument) {
        XDSStatusElement xDSStatusElement = null;
        XDSParameterException xDSParameterException2 = xDSParameterException;
        while (xDSParameterException2 != null) {
            xDSStatusElement = XDSUtil.appendStatus(statusDocument, statusAttributes, xDSParameterException2.getMessage());
            xDSParameterException2 = xDSParameterException2.getNext();
        }
        if (xDSStatusElement != null && xmlDocument != null) {
            xDSStatusElement.documentAppend(xmlDocument);
        }
        return xDSStatusElement;
    }

    private static String getDescription(String string, Exception exception) {
        if (string == null) {
            if (exception == null) {
                return null;
            }
            return exception.toString();
        }
        return string;
    }

    public static XDSStatusElement appendStatus(StatusDocument statusDocument, StatusAttributes statusAttributes, String string, Exception exception, boolean bl, XmlDocument xmlDocument) {
        XDSStatusElement xDSStatusElement = null;
        if (statusDocument != null) {
            if (exception instanceof XDSParameterException) {
                xDSStatusElement = XDSUtil.appendStatus(statusDocument, statusAttributes, (XDSParameterException)exception, xmlDocument);
            } else {
                xDSStatusElement = statusDocument.appendStatusElement();
                if (statusAttributes != null) {
                    xDSStatusElement.setLevel(statusAttributes.getLevel());
                    xDSStatusElement.setType(statusAttributes.getType());
                    xDSStatusElement.setEventID(statusAttributes.getEventID());
                }
                xDSStatusElement.descriptionAppend(XDSUtil.getDescription(string, exception));
                xDSStatusElement.exceptionAppend(exception, bl);
                xDSStatusElement.documentAppend(xmlDocument);
            }
        }
        return xDSStatusElement;
    }

    public static void appendXML(Element element, String string) {
        if (XDSUtil.isValue(string) && element != null) {
            Node node;
            Document document = element.getOwnerDocument();
            XmlDocument xmlDocument = new XmlDocument(string);
            Document document2 = xmlDocument.getDocument();
            if (document2 != null && (node = Lib.cloneSubtree(document, document2.getDocumentElement())) != null) {
                element.appendChild(node);
            }
        }
    }

    public static boolean appendStackTrace(Exception exception) {
        return exception instanceof RuntimeException;
    }

    public static boolean isValue(String string) {
        return string != null && "".compareTo(string) != 0;
    }

    public static boolean noValue(String string) {
        return string == null || "".compareTo(string) == 0;
    }

    private static String toNull(String string) {
        if (XDSUtil.noValue(string)) {
            return null;
        }
        return string;
    }

    public static String getChildText(Element element) {
        element.normalize();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            short s = nodeList.item(n).getNodeType();
            if (s == 3) {
                Text text = (Text)nodeList.item(n);
                return XDSUtil.toNull(text.getData());
            }
            ++n;
        }
        return null;
    }
}

