/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Message;
import com.phaos.SSL.SSLException;
import com.phaos.utils.InvalidInputException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public final class Alert
extends Message {
    private static final int type = 21;
    private Error error;
    private Level level;

    public Alert(Level level, Error error) {
        this.error = error;
        this.level = level;
    }

    public Alert(InputStream inputStream) throws IOException {
        this.input(inputStream);
        if (this.level.getValue() == Level.FATAL.getValue()) {
            throw new SSLException("Fatal alert received. Error: " + this.error, this.error);
        }
    }

    public Error getError() {
        return this.error;
    }

    public Level getLevel() {
        return this.level;
    }

    public int getType() {
        return 21;
    }

    public void input(InputStream inputStream) throws IOException {
        this.level = Level.inputInstance(inputStream);
        this.error = Error.inputInstance(inputStream);
    }

    public int length() {
        return 2;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.level.getValue());
        outputStream.write(this.error.getValue());
    }

    public String toString() {
        return "Alert: Level = " + this.level + ", Error = " + this.error;
    }

    public static final class Level {
        public static final Level WARNING = new Level(1);
        public static final Level FATAL = new Level(2);
        private int value;

        private Level(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }

        public static Level inputInstance(InputStream inputStream) throws IOException {
            int n = inputStream.read();
            if (n == WARNING.getValue()) {
                return WARNING;
            }
            if (n == FATAL.getValue()) {
                return FATAL;
            }
            throw new InvalidInputException("Alert level unrecognized");
        }

        public String toString() {
            if (this.value == WARNING.getValue()) {
                return "WARNING";
            }
            if (this.value == FATAL.getValue()) {
                return "FATAL";
            }
            return "UNKNOWN";
        }
    }

    public static final class Error {
        public static final Error CLOSE_NOTIFY = new Error(0, "CLOSE NOTIFY");
        public static final Error UNEXPECTED_MESSAGE = new Error(10, "UNEXPECTED MESSAGE");
        public static final Error BAD_RECORD_MAC = new Error(20, "BAD RECORD MAC");
        public static final Error DECOMPRESSION_FAILURE = new Error(30, "DECOMPRESSION FAILURE");
        public static final Error HANDSHAKE_FAILURE = new Error(40, "HANDSHAKE FAILURE");
        public static final Error NO_CERTIFICATE = new Error(41, "NO CERTIFICATE");
        public static final Error BAD_CERTIFICATE = new Error(42, "BAD CERTIFICATE");
        public static final Error UNSUPPORTED_CERTIFICATE = new Error(43, "UNSUPPORTED CERTIFICATE");
        public static final Error CERTIFICATE_REVOKED = new Error(44, "CERTIFICATE REVOKED");
        public static final Error CERTIFICATE_EXPIRED = new Error(45, "CERTIFICATE EXPIRED");
        public static final Error CERTIFICATE_UNKNOWN = new Error(46, "CERTIFICATE UNKNOWN");
        public static final Error ILLEGAL_PARAMETER = new Error(47, "ILLEGAL PARAMETER");
        public static final Error DECRYPTION_FAILED = new Error(21, "DECRYPTION FAILED");
        public static final Error RECORD_OVERFLOW = new Error(22, "RECORD OVERFLOW");
        public static final Error UNKNOWN_CA = new Error(48, "UNKNOWN CA");
        public static final Error ACCESS_DENIED = new Error(49, "ACCESS DENIED");
        public static final Error DECODE_ERROR = new Error(50, "DECODE ERROR");
        public static final Error DECRYPT_ERROR = new Error(51, "DECRYPT ERROR");
        public static final Error EXPORT_RESTRICTION = new Error(60, "EXPORT RESTRICTION");
        public static final Error PROTOCOL_VERSION = new Error(70, "PROTOCOL VERSION");
        public static final Error INSUFFICIENT_SECURITY = new Error(71, "INSUFFICIENT SECURITY");
        public static final Error INTERNAL_ERROR = new Error(80, "INTERNAL ERROR");
        public static final Error USER_CANCELED = new Error(90, "USER CANCELED");
        public static final Error NO_RENEGOTIATION = new Error(100, "NO RENEGOTIATION");
        private int value;
        private String description;
        private static Hashtable errors;

        private Error(int n, String string) {
            this.value = n;
            this.description = string;
            if (errors == null) {
                errors = new Hashtable();
            }
            errors.put(new Integer(n), this);
        }

        public int getValue() {
            return this.value;
        }

        public static Error inputInstance(InputStream inputStream) throws IOException {
            int n = inputStream.read();
            if (errors.containsKey(new Integer(n))) {
                return (Error)errors.get(new Integer(n));
            }
            throw new InvalidInputException("Alert error unrecognized");
        }

        public String toString() {
            return this.description;
        }
    }
}

